/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.UsageProperties;
import com.azure.resourcemanager.appservice.models.ComputeModeOptions;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class UsageInner
extends ProxyOnlyResource {
    private UsageProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private UsageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public UsageInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    public String resourceName() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceName();
    }

    public String unit() {
        return this.innerProperties() == null ? null : this.innerProperties().unit();
    }

    public Long currentValue() {
        return this.innerProperties() == null ? null : this.innerProperties().currentValue();
    }

    public Long limit() {
        return this.innerProperties() == null ? null : this.innerProperties().limit();
    }

    public OffsetDateTime nextResetTime() {
        return this.innerProperties() == null ? null : this.innerProperties().nextResetTime();
    }

    public ComputeModeOptions computeMode() {
        return this.innerProperties() == null ? null : this.innerProperties().computeMode();
    }

    public String siteMode() {
        return this.innerProperties() == null ? null : this.innerProperties().siteMode();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static UsageInner fromJson(JsonReader jsonReader) throws IOException {
        return (UsageInner)((Object)jsonReader.readObject(reader -> {
            UsageInner deserializedUsageInner = new UsageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedUsageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUsageInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUsageInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedUsageInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedUsageInner.innerProperties = UsageProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUsageInner;
        }));
    }
}

