/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyValuePairStringObject;
import java.io.IOException;
import java.util.List;

public final class DataProviderMetadata
implements JsonSerializable<DataProviderMetadata> {
    private String providerName;
    private List<KeyValuePairStringObject> propertyBag;

    public String providerName() {
        return this.providerName;
    }

    public DataProviderMetadata withProviderName(String providerName) {
        this.providerName = providerName;
        return this;
    }

    public List<KeyValuePairStringObject> propertyBag() {
        return this.propertyBag;
    }

    public void validate() {
        if (this.propertyBag() != null) {
            this.propertyBag().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("providerName", this.providerName);
        return jsonWriter.writeEndObject();
    }

    public static DataProviderMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (DataProviderMetadata)jsonReader.readObject(reader -> {
            DataProviderMetadata deserializedDataProviderMetadata = new DataProviderMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("providerName".equals(fieldName)) {
                    deserializedDataProviderMetadata.providerName = reader.getString();
                    continue;
                }
                if ("propertyBag".equals(fieldName)) {
                    List propertyBag;
                    deserializedDataProviderMetadata.propertyBag = propertyBag = reader.readArray(reader1 -> KeyValuePairStringObject.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataProviderMetadata;
        });
    }
}

