/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DetectorDefinitionResourceInner;
import java.io.IOException;
import java.util.List;

public final class DiagnosticDetectorCollection
implements JsonSerializable<DiagnosticDetectorCollection> {
    private List<DetectorDefinitionResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DiagnosticDetectorCollection.class);

    public List<DetectorDefinitionResourceInner> value() {
        return this.value;
    }

    public DiagnosticDetectorCollection withValue(List<DetectorDefinitionResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DiagnosticDetectorCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiagnosticDetectorCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DiagnosticDetectorCollection)jsonReader.readObject(reader -> {
            DiagnosticDetectorCollection deserializedDiagnosticDetectorCollection = new DiagnosticDetectorCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDiagnosticDetectorCollection.value = value = reader.readArray(reader1 -> DetectorDefinitionResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDiagnosticDetectorCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiagnosticDetectorCollection;
        });
    }
}

