/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.DomainInner;
import java.io.IOException;
import java.util.List;

public final class DomainCollection
implements JsonSerializable<DomainCollection> {
    private List<DomainInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(DomainCollection.class);

    public List<DomainInner> value() {
        return this.value;
    }

    public DomainCollection withValue(List<DomainInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model DomainCollection"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DomainCollection fromJson(JsonReader jsonReader) throws IOException {
        return (DomainCollection)jsonReader.readObject(reader -> {
            DomainCollection deserializedDomainCollection = new DomainCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedDomainCollection.value = value = reader.readArray(reader1 -> DomainInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedDomainCollection.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDomainCollection;
        });
    }
}

