/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VirtualIpMapping
implements JsonSerializable<VirtualIpMapping> {
    private String virtualIp;
    private Integer internalHttpPort;
    private Integer internalHttpsPort;
    private Boolean inUse;
    private String serviceName;

    public String virtualIp() {
        return this.virtualIp;
    }

    public VirtualIpMapping withVirtualIp(String virtualIp) {
        this.virtualIp = virtualIp;
        return this;
    }

    public Integer internalHttpPort() {
        return this.internalHttpPort;
    }

    public VirtualIpMapping withInternalHttpPort(Integer internalHttpPort) {
        this.internalHttpPort = internalHttpPort;
        return this;
    }

    public Integer internalHttpsPort() {
        return this.internalHttpsPort;
    }

    public VirtualIpMapping withInternalHttpsPort(Integer internalHttpsPort) {
        this.internalHttpsPort = internalHttpsPort;
        return this;
    }

    public Boolean inUse() {
        return this.inUse;
    }

    public VirtualIpMapping withInUse(Boolean inUse) {
        this.inUse = inUse;
        return this;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public VirtualIpMapping withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("virtualIP", this.virtualIp);
        jsonWriter.writeNumberField("internalHttpPort", (Number)this.internalHttpPort);
        jsonWriter.writeNumberField("internalHttpsPort", (Number)this.internalHttpsPort);
        jsonWriter.writeBooleanField("inUse", this.inUse);
        jsonWriter.writeStringField("serviceName", this.serviceName);
        return jsonWriter.writeEndObject();
    }

    public static VirtualIpMapping fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualIpMapping)jsonReader.readObject(reader -> {
            VirtualIpMapping deserializedVirtualIpMapping = new VirtualIpMapping();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualIP".equals(fieldName)) {
                    deserializedVirtualIpMapping.virtualIp = reader.getString();
                    continue;
                }
                if ("internalHttpPort".equals(fieldName)) {
                    deserializedVirtualIpMapping.internalHttpPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("internalHttpsPort".equals(fieldName)) {
                    deserializedVirtualIpMapping.internalHttpsPort = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("inUse".equals(fieldName)) {
                    deserializedVirtualIpMapping.inUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("serviceName".equals(fieldName)) {
                    deserializedVirtualIpMapping.serviceName = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualIpMapping;
        });
    }
}

