/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphConversationThread;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphConversation
extends MicrosoftGraphEntity {
    private Boolean hasAttachments;
    private OffsetDateTime lastDeliveredDateTime;
    private String preview;
    private String topic;
    private List<String> uniqueSenders;
    private List<MicrosoftGraphConversationThread> threads;
    private Map<String, Object> additionalProperties;

    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    public MicrosoftGraphConversation withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    public OffsetDateTime lastDeliveredDateTime() {
        return this.lastDeliveredDateTime;
    }

    public MicrosoftGraphConversation withLastDeliveredDateTime(OffsetDateTime lastDeliveredDateTime) {
        this.lastDeliveredDateTime = lastDeliveredDateTime;
        return this;
    }

    public String preview() {
        return this.preview;
    }

    public MicrosoftGraphConversation withPreview(String preview) {
        this.preview = preview;
        return this;
    }

    public String topic() {
        return this.topic;
    }

    public MicrosoftGraphConversation withTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public List<String> uniqueSenders() {
        return this.uniqueSenders;
    }

    public MicrosoftGraphConversation withUniqueSenders(List<String> uniqueSenders) {
        this.uniqueSenders = uniqueSenders;
        return this;
    }

    public List<MicrosoftGraphConversationThread> threads() {
        return this.threads;
    }

    public MicrosoftGraphConversation withThreads(List<MicrosoftGraphConversationThread> threads) {
        this.threads = threads;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphConversation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphConversation withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.threads() != null) {
            this.threads().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeStringField("lastDeliveredDateTime", this.lastDeliveredDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastDeliveredDateTime));
        jsonWriter.writeStringField("preview", this.preview);
        jsonWriter.writeStringField("topic", this.topic);
        jsonWriter.writeArrayField("uniqueSenders", this.uniqueSenders, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("threads", this.threads, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphConversation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphConversation)jsonReader.readObject(reader -> {
            MicrosoftGraphConversation deserializedMicrosoftGraphConversation = new MicrosoftGraphConversation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.withId(reader.getString());
                    continue;
                }
                if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.hasAttachments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastDeliveredDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.lastDeliveredDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("preview".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.preview = reader.getString();
                    continue;
                }
                if ("topic".equals(fieldName)) {
                    deserializedMicrosoftGraphConversation.topic = reader.getString();
                    continue;
                }
                if ("uniqueSenders".equals(fieldName)) {
                    List uniqueSenders;
                    deserializedMicrosoftGraphConversation.uniqueSenders = uniqueSenders = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("threads".equals(fieldName)) {
                    List threads;
                    deserializedMicrosoftGraphConversation.threads = threads = reader.readArray(reader1 -> MicrosoftGraphConversationThread.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphConversation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphConversation;
        });
    }
}

