/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphActionState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphDeviceActionResult
implements JsonSerializable<MicrosoftGraphDeviceActionResult> {
    private String actionName;
    private MicrosoftGraphActionState actionState;
    private OffsetDateTime lastUpdatedDateTime;
    private OffsetDateTime startDateTime;
    private Map<String, Object> additionalProperties;

    public String actionName() {
        return this.actionName;
    }

    public MicrosoftGraphDeviceActionResult withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    public MicrosoftGraphActionState actionState() {
        return this.actionState;
    }

    public MicrosoftGraphDeviceActionResult withActionState(MicrosoftGraphActionState actionState) {
        this.actionState = actionState;
        return this;
    }

    public OffsetDateTime lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public MicrosoftGraphDeviceActionResult withLastUpdatedDateTime(OffsetDateTime lastUpdatedDateTime) {
        this.lastUpdatedDateTime = lastUpdatedDateTime;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public MicrosoftGraphDeviceActionResult withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphDeviceActionResult withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeStringField("actionState", this.actionState == null ? null : this.actionState.toString());
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedDateTime));
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDeviceActionResult fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphDeviceActionResult)jsonReader.readObject(reader -> {
            MicrosoftGraphDeviceActionResult deserializedMicrosoftGraphDeviceActionResult = new MicrosoftGraphDeviceActionResult();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("actionName".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.actionName = reader.getString();
                    continue;
                }
                if ("actionState".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.actionState = MicrosoftGraphActionState.fromString(reader.getString());
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.lastUpdatedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDeviceActionResult.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDeviceActionResult.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDeviceActionResult;
        });
    }
}

