/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphBaseItemInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphContentTypeInfo;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDriveItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFieldValueSet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemAnalytics;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphListItemVersion;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharepointIds;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphListItem
extends MicrosoftGraphBaseItemInner {
    private MicrosoftGraphContentTypeInfo contentType;
    private MicrosoftGraphSharepointIds sharepointIds;
    private MicrosoftGraphItemAnalytics analytics;
    private MicrosoftGraphDriveItem driveItem;
    private MicrosoftGraphFieldValueSet fields;
    private List<MicrosoftGraphListItemVersion> versions;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphContentTypeInfo contentType() {
        return this.contentType;
    }

    public MicrosoftGraphListItem withContentType(MicrosoftGraphContentTypeInfo contentType) {
        this.contentType = contentType;
        return this;
    }

    public MicrosoftGraphSharepointIds sharepointIds() {
        return this.sharepointIds;
    }

    public MicrosoftGraphListItem withSharepointIds(MicrosoftGraphSharepointIds sharepointIds) {
        this.sharepointIds = sharepointIds;
        return this;
    }

    public MicrosoftGraphItemAnalytics analytics() {
        return this.analytics;
    }

    public MicrosoftGraphListItem withAnalytics(MicrosoftGraphItemAnalytics analytics) {
        this.analytics = analytics;
        return this;
    }

    public MicrosoftGraphDriveItem driveItem() {
        return this.driveItem;
    }

    public MicrosoftGraphListItem withDriveItem(MicrosoftGraphDriveItem driveItem) {
        this.driveItem = driveItem;
        return this;
    }

    public MicrosoftGraphFieldValueSet fields() {
        return this.fields;
    }

    public MicrosoftGraphListItem withFields(MicrosoftGraphFieldValueSet fields) {
        this.fields = fields;
        return this;
    }

    public List<MicrosoftGraphListItemVersion> versions() {
        return this.versions;
    }

    public MicrosoftGraphListItem withVersions(List<MicrosoftGraphListItemVersion> versions) {
        this.versions = versions;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphListItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphListItem withCreatedBy(MicrosoftGraphIdentitySet createdBy) {
        super.withCreatedBy(createdBy);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withEtag(String etag) {
        super.withEtag(etag);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withParentReference(MicrosoftGraphItemReference parentReference) {
        super.withParentReference(parentReference);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withWebUrl(String webUrl) {
        super.withWebUrl(webUrl);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withCreatedByUser(MicrosoftGraphUserInner createdByUser) {
        super.withCreatedByUser(createdByUser);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withLastModifiedByUser(MicrosoftGraphUserInner lastModifiedByUser) {
        super.withLastModifiedByUser(lastModifiedByUser);
        return this;
    }

    @Override
    public MicrosoftGraphListItem withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.contentType() != null) {
            this.contentType().validate();
        }
        if (this.sharepointIds() != null) {
            this.sharepointIds().validate();
        }
        if (this.analytics() != null) {
            this.analytics().validate();
        }
        if (this.driveItem() != null) {
            this.driveItem().validate();
        }
        if (this.fields() != null) {
            this.fields().validate();
        }
        if (this.versions() != null) {
            this.versions().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("createdBy", (JsonSerializable)this.createdBy());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("eTag", this.etag());
        jsonWriter.writeJsonField("lastModifiedBy", (JsonSerializable)this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeJsonField("parentReference", (JsonSerializable)this.parentReference());
        jsonWriter.writeStringField("webUrl", this.webUrl());
        jsonWriter.writeJsonField("createdByUser", (JsonSerializable)this.createdByUser());
        jsonWriter.writeJsonField("lastModifiedByUser", (JsonSerializable)this.lastModifiedByUser());
        jsonWriter.writeJsonField("contentType", (JsonSerializable)this.contentType);
        jsonWriter.writeJsonField("sharepointIds", (JsonSerializable)this.sharepointIds);
        jsonWriter.writeJsonField("analytics", (JsonSerializable)this.analytics);
        jsonWriter.writeJsonField("driveItem", (JsonSerializable)this.driveItem);
        jsonWriter.writeJsonField("fields", (JsonSerializable)this.fields);
        jsonWriter.writeArrayField("versions", this.versions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphListItem fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphListItem)jsonReader.readObject(reader -> {
            MicrosoftGraphListItem deserializedMicrosoftGraphListItem = new MicrosoftGraphListItem();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withId(reader.getString());
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withCreatedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withDescription(reader.getString());
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withEtag(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withName(reader.getString());
                    continue;
                }
                if ("parentReference".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withParentReference(MicrosoftGraphItemReference.fromJson(reader));
                    continue;
                }
                if ("webUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withWebUrl(reader.getString());
                    continue;
                }
                if ("createdByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withCreatedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("lastModifiedByUser".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.withLastModifiedByUser(MicrosoftGraphUserInner.fromJson(reader));
                    continue;
                }
                if ("contentType".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.contentType = MicrosoftGraphContentTypeInfo.fromJson(reader);
                    continue;
                }
                if ("sharepointIds".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.sharepointIds = MicrosoftGraphSharepointIds.fromJson(reader);
                    continue;
                }
                if ("analytics".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.analytics = MicrosoftGraphItemAnalytics.fromJson(reader);
                    continue;
                }
                if ("driveItem".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.driveItem = MicrosoftGraphDriveItem.fromJson(reader);
                    continue;
                }
                if ("fields".equals(fieldName)) {
                    deserializedMicrosoftGraphListItem.fields = MicrosoftGraphFieldValueSet.fromJson(reader);
                    continue;
                }
                if ("versions".equals(fieldName)) {
                    List versions;
                    deserializedMicrosoftGraphListItem.versions = versions = reader.readArray(reader1 -> MicrosoftGraphListItemVersion.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphListItem.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphListItem;
        });
    }
}

