/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharedInsight;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTrending;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUsedInsight;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOfficeGraphInsights
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphSharedInsight> shared;
    private List<MicrosoftGraphTrending> trending;
    private List<MicrosoftGraphUsedInsight> used;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphSharedInsight> shared() {
        return this.shared;
    }

    public MicrosoftGraphOfficeGraphInsights withShared(List<MicrosoftGraphSharedInsight> shared) {
        this.shared = shared;
        return this;
    }

    public List<MicrosoftGraphTrending> trending() {
        return this.trending;
    }

    public MicrosoftGraphOfficeGraphInsights withTrending(List<MicrosoftGraphTrending> trending) {
        this.trending = trending;
        return this;
    }

    public List<MicrosoftGraphUsedInsight> used() {
        return this.used;
    }

    public MicrosoftGraphOfficeGraphInsights withUsed(List<MicrosoftGraphUsedInsight> used) {
        this.used = used;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOfficeGraphInsights withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOfficeGraphInsights withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.shared() != null) {
            this.shared().forEach(e -> e.validate());
        }
        if (this.trending() != null) {
            this.trending().forEach(e -> e.validate());
        }
        if (this.used() != null) {
            this.used().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("shared", this.shared, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("trending", this.trending, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("used", this.used, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOfficeGraphInsights fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOfficeGraphInsights)jsonReader.readObject(reader -> {
            MicrosoftGraphOfficeGraphInsights deserializedMicrosoftGraphOfficeGraphInsights = new MicrosoftGraphOfficeGraphInsights();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOfficeGraphInsights.withId(reader.getString());
                    continue;
                }
                if ("shared".equals(fieldName)) {
                    List shared;
                    deserializedMicrosoftGraphOfficeGraphInsights.shared = shared = reader.readArray(reader1 -> MicrosoftGraphSharedInsight.fromJson(reader1));
                    continue;
                }
                if ("trending".equals(fieldName)) {
                    List trending;
                    deserializedMicrosoftGraphOfficeGraphInsights.trending = trending = reader.readArray(reader1 -> MicrosoftGraphTrending.fromJson(reader1));
                    continue;
                }
                if ("used".equals(fieldName)) {
                    List used;
                    deserializedMicrosoftGraphOfficeGraphInsights.used = used = reader.readArray(reader1 -> MicrosoftGraphUsedInsight.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOfficeGraphInsights.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOfficeGraphInsights;
        });
    }
}

