/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPhone;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOnlineMeetingInfo
implements JsonSerializable<MicrosoftGraphOnlineMeetingInfo> {
    private String conferenceId;
    private String joinUrl;
    private List<MicrosoftGraphPhone> phones;
    private String quickDial;
    private List<String> tollFreeNumbers;
    private String tollNumber;
    private Map<String, Object> additionalProperties;

    public String conferenceId() {
        return this.conferenceId;
    }

    public MicrosoftGraphOnlineMeetingInfo withConferenceId(String conferenceId) {
        this.conferenceId = conferenceId;
        return this;
    }

    public String joinUrl() {
        return this.joinUrl;
    }

    public MicrosoftGraphOnlineMeetingInfo withJoinUrl(String joinUrl) {
        this.joinUrl = joinUrl;
        return this;
    }

    public List<MicrosoftGraphPhone> phones() {
        return this.phones;
    }

    public MicrosoftGraphOnlineMeetingInfo withPhones(List<MicrosoftGraphPhone> phones) {
        this.phones = phones;
        return this;
    }

    public String quickDial() {
        return this.quickDial;
    }

    public MicrosoftGraphOnlineMeetingInfo withQuickDial(String quickDial) {
        this.quickDial = quickDial;
        return this;
    }

    public List<String> tollFreeNumbers() {
        return this.tollFreeNumbers;
    }

    public MicrosoftGraphOnlineMeetingInfo withTollFreeNumbers(List<String> tollFreeNumbers) {
        this.tollFreeNumbers = tollFreeNumbers;
        return this;
    }

    public String tollNumber() {
        return this.tollNumber;
    }

    public MicrosoftGraphOnlineMeetingInfo withTollNumber(String tollNumber) {
        this.tollNumber = tollNumber;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphOnlineMeetingInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.phones() != null) {
            this.phones().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("conferenceId", this.conferenceId);
        jsonWriter.writeStringField("joinUrl", this.joinUrl);
        jsonWriter.writeArrayField("phones", this.phones, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("quickDial", this.quickDial);
        jsonWriter.writeArrayField("tollFreeNumbers", this.tollFreeNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("tollNumber", this.tollNumber);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnlineMeetingInfo fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnlineMeetingInfo)jsonReader.readObject(reader -> {
            MicrosoftGraphOnlineMeetingInfo deserializedMicrosoftGraphOnlineMeetingInfo = new MicrosoftGraphOnlineMeetingInfo();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("conferenceId".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeetingInfo.conferenceId = reader.getString();
                    continue;
                }
                if ("joinUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeetingInfo.joinUrl = reader.getString();
                    continue;
                }
                if ("phones".equals(fieldName)) {
                    List phones;
                    deserializedMicrosoftGraphOnlineMeetingInfo.phones = phones = reader.readArray(reader1 -> MicrosoftGraphPhone.fromJson(reader1));
                    continue;
                }
                if ("quickDial".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeetingInfo.quickDial = reader.getString();
                    continue;
                }
                if ("tollFreeNumbers".equals(fieldName)) {
                    List tollFreeNumbers;
                    deserializedMicrosoftGraphOnlineMeetingInfo.tollFreeNumbers = tollFreeNumbers = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("tollNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphOnlineMeetingInfo.tollNumber = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnlineMeetingInfo.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnlineMeetingInfo;
        });
    }
}

