/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.CdnWebApplicationFirewallPolicyProperties;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class CdnWebApplicationFirewallPolicyInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CdnWebApplicationFirewallPolicyInner.class);
    @JsonProperty(value="properties")
    private CdnWebApplicationFirewallPolicyProperties innerProperties;
    @JsonProperty(value="etag")
    private String etag;
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    private CdnWebApplicationFirewallPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public String etag() {
        return this.etag;
    }

    public CdnWebApplicationFirewallPolicyInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public CdnWebApplicationFirewallPolicyInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public CdnWebApplicationFirewallPolicyInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CdnWebApplicationFirewallPolicyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public PolicySettings policySettings() {
        return this.innerProperties() == null ? null : this.innerProperties().policySettings();
    }

    public CdnWebApplicationFirewallPolicyInner withPolicySettings(PolicySettings policySettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withPolicySettings(policySettings);
        return this;
    }

    public RateLimitRuleList rateLimitRules() {
        return this.innerProperties() == null ? null : this.innerProperties().rateLimitRules();
    }

    public CdnWebApplicationFirewallPolicyInner withRateLimitRules(RateLimitRuleList rateLimitRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withRateLimitRules(rateLimitRules);
        return this;
    }

    public CustomRuleList customRules() {
        return this.innerProperties() == null ? null : this.innerProperties().customRules();
    }

    public CdnWebApplicationFirewallPolicyInner withCustomRules(CustomRuleList customRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withCustomRules(customRules);
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.innerProperties() == null ? null : this.innerProperties().managedRules();
    }

    public CdnWebApplicationFirewallPolicyInner withManagedRules(ManagedRuleSetList managedRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CdnWebApplicationFirewallPolicyProperties();
        }
        this.innerProperties().withManagedRules(managedRules);
        return this;
    }

    public List<EndpointResource> endpointLinks() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointLinks();
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public PolicyResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model CdnWebApplicationFirewallPolicyInner"));
        }
        this.sku().validate();
    }
}

