/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.CustomRuleList;
import com.azure.resourcemanager.cdn.models.EndpointResource;
import com.azure.resourcemanager.cdn.models.ManagedRuleSetList;
import com.azure.resourcemanager.cdn.models.PolicyResourceState;
import com.azure.resourcemanager.cdn.models.PolicySettings;
import com.azure.resourcemanager.cdn.models.ProvisioningState;
import com.azure.resourcemanager.cdn.models.RateLimitRuleList;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class CdnWebApplicationFirewallPolicyProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(CdnWebApplicationFirewallPolicyProperties.class);
    @JsonProperty(value="policySettings")
    private PolicySettings policySettings;
    @JsonProperty(value="rateLimitRules")
    private RateLimitRuleList rateLimitRules;
    @JsonProperty(value="customRules")
    private CustomRuleList customRules;
    @JsonProperty(value="managedRules")
    private ManagedRuleSetList managedRules;
    @JsonProperty(value="endpointLinks", access=JsonProperty.Access.WRITE_ONLY)
    private List<EndpointResource> endpointLinks;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private PolicyResourceState resourceState;

    public PolicySettings policySettings() {
        return this.policySettings;
    }

    public CdnWebApplicationFirewallPolicyProperties withPolicySettings(PolicySettings policySettings) {
        this.policySettings = policySettings;
        return this;
    }

    public RateLimitRuleList rateLimitRules() {
        return this.rateLimitRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withRateLimitRules(RateLimitRuleList rateLimitRules) {
        this.rateLimitRules = rateLimitRules;
        return this;
    }

    public CustomRuleList customRules() {
        return this.customRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withCustomRules(CustomRuleList customRules) {
        this.customRules = customRules;
        return this;
    }

    public ManagedRuleSetList managedRules() {
        return this.managedRules;
    }

    public CdnWebApplicationFirewallPolicyProperties withManagedRules(ManagedRuleSetList managedRules) {
        this.managedRules = managedRules;
        return this;
    }

    public List<EndpointResource> endpointLinks() {
        return this.endpointLinks;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public PolicyResourceState resourceState() {
        return this.resourceState;
    }

    public void validate() {
        if (this.policySettings() != null) {
            this.policySettings().validate();
        }
        if (this.rateLimitRules() != null) {
            this.rateLimitRules().validate();
        }
        if (this.customRules() != null) {
            this.customRules().validate();
        }
        if (this.managedRules() != null) {
            this.managedRules().validate();
        }
        if (this.endpointLinks() != null) {
            this.endpointLinks().forEach(e -> e.validate());
        }
    }
}

