/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ProfileProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProfileProperties.class);
    @JsonProperty(value="resourceState", access=JsonProperty.Access.WRITE_ONLY)
    private ProfileResourceState resourceState;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="frontDoorId", access=JsonProperty.Access.WRITE_ONLY)
    private String frontDoorId;
    @JsonProperty(value="originResponseTimeoutSeconds")
    private Integer originResponseTimeoutSeconds;

    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ProfileProperties withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String frontDoorId() {
        return this.frontDoorId;
    }

    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    public ProfileProperties withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

