/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.cdn.fluent.models.ProfileProperties;
import com.azure.resourcemanager.cdn.models.ManagedServiceIdentity;
import com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import com.azure.resourcemanager.cdn.models.Sku;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class ProfileInner
extends Resource {
    @JsonProperty(value="sku", required=true)
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private String kind;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;
    @JsonProperty(value="properties")
    private ProfileProperties innerProperties;
    @JsonProperty(value="systemData", access=JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;
    private static final ClientLogger LOGGER = new ClientLogger(ProfileInner.class);

    public Sku sku() {
        return this.sku;
    }

    public ProfileInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public String kind() {
        return this.kind;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public ProfileInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ProfileProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public ProfileInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProfileInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProfileResourceState resourceState() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceState();
    }

    public ProfileProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Map<String, String> extendedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().extendedProperties();
    }

    public String frontDoorId() {
        return this.innerProperties() == null ? null : this.innerProperties().frontDoorId();
    }

    public Integer originResponseTimeoutSeconds() {
        return this.innerProperties() == null ? null : this.innerProperties().originResponseTimeoutSeconds();
    }

    public ProfileInner withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ProfileProperties();
        }
        this.innerProperties().withOriginResponseTimeoutSeconds(originResponseTimeoutSeconds);
        return this;
    }

    public void validate() {
        if (this.sku() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sku in model ProfileInner"));
        }
        this.sku().validate();
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

