// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Algorithm to use for URL signing. */
public final class Algorithm extends ExpandableStringEnum<Algorithm> {
    /** Static value SHA256 for Algorithm. */
    public static final Algorithm SHA256 = fromString("SHA256");

    /**
     * Creates a new instance of Algorithm value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public Algorithm() {
    }

    /**
     * Creates or finds a Algorithm from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding Algorithm.
     */
    @JsonCreator
    public static Algorithm fromString(String name) {
        return fromString(name, Algorithm.class);
    }

    /**
     * Gets known Algorithm values.
     *
     * @return known Algorithm values.
     */
    public static Collection<Algorithm> values() {
        return values(Algorithm.class);
    }
}
