/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageInner;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.azure.resourcemanager.compute.models.DiskStorageAccountTypes;
import com.azure.resourcemanager.compute.models.Gallery;
import com.azure.resourcemanager.compute.models.GalleryImage;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.GalleryImageUpdate;
import com.azure.resourcemanager.compute.models.GalleryImageVersion;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.azure.resourcemanager.compute.models.ResourceRange;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

class GalleryImageImpl
extends CreatableUpdatableImpl<GalleryImage, GalleryImageInner, GalleryImageImpl>
implements GalleryImage,
GalleryImage.Definition,
GalleryImage.Update {
    private final ComputeManager manager;
    private String resourceGroupName;
    private String galleryName;
    private String galleryImageName;
    private GalleryImageUpdate galleryImageUpdate;

    GalleryImageImpl(String name, ComputeManager manager) {
        super(name, (Object)new GalleryImageInner());
        this.manager = manager;
        this.galleryImageName = name;
    }

    GalleryImageImpl(GalleryImageInner inner, ComputeManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.galleryImageName = inner.name();
        this.resourceGroupName = GalleryImageImpl.getValueFromIdByName(inner.id(), "resourceGroups");
        this.galleryName = GalleryImageImpl.getValueFromIdByName(inner.id(), "galleries");
        this.galleryImageName = GalleryImageImpl.getValueFromIdByName(inner.id(), "images");
    }

    @Override
    public Mono<GalleryImageVersion> getVersionAsync(String versionName) {
        return this.manager().galleryImageVersions().getByGalleryImageAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, versionName);
    }

    @Override
    public GalleryImageVersion getVersion(String versionName) {
        return this.manager().galleryImageVersions().getByGalleryImage(this.resourceGroupName, this.galleryName, this.galleryImageName, versionName);
    }

    @Override
    public PagedFlux<GalleryImageVersion> listVersionsAsync() {
        return this.manager().galleryImageVersions().listByGalleryImageAsync(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    @Override
    public PagedIterable<GalleryImageVersion> listVersions() {
        return this.manager().galleryImageVersions().listByGalleryImage(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    public ComputeManager manager() {
        return this.manager;
    }

    public Mono<GalleryImage> createResourceAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImages().createOrUpdateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, (GalleryImageInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public GalleryImageImpl update() {
        this.galleryImageUpdate = new GalleryImageUpdate();
        return (GalleryImageImpl)super.update();
    }

    public Mono<GalleryImage> updateResourceAsync() {
        this.galleryImageUpdate.withOsState(((GalleryImageInner)((Object)this.innerModel())).osState()).withOsType(((GalleryImageInner)((Object)this.innerModel())).osType()).withIdentifier(((GalleryImageInner)((Object)this.innerModel())).identifier());
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImages().updateAsync(this.resourceGroupName, this.galleryName, this.galleryImageName, this.galleryImageUpdate).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<GalleryImageInner> getInnerAsync() {
        return ((ComputeManagementClient)this.manager().serviceClient()).getGalleryImages().getAsync(this.resourceGroupName, this.galleryName, this.galleryImageName);
    }

    public boolean isInCreateMode() {
        return ((GalleryImageInner)((Object)this.innerModel())).id() == null;
    }

    @Override
    public String description() {
        return ((GalleryImageInner)((Object)this.innerModel())).description();
    }

    @Override
    public List<DiskSkuTypes> unsupportedDiskTypes() {
        if (((GalleryImageInner)((Object)this.innerModel())).disallowed() == null || ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes() == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        ArrayList<DiskSkuTypes> diskTypes = new ArrayList<DiskSkuTypes>();
        for (String diskTypeStr : ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes()) {
            diskTypes.add(DiskSkuTypes.fromStorageAccountType(DiskStorageAccountTypes.fromString(diskTypeStr)));
        }
        return Collections.unmodifiableList(diskTypes);
    }

    @Override
    public Disallowed disallowed() {
        return ((GalleryImageInner)((Object)this.innerModel())).disallowed();
    }

    @Override
    public OffsetDateTime endOfLifeDate() {
        return ((GalleryImageInner)((Object)this.innerModel())).endOfLifeDate();
    }

    @Override
    public String eula() {
        return ((GalleryImageInner)((Object)this.innerModel())).eula();
    }

    @Override
    public String id() {
        return ((GalleryImageInner)((Object)this.innerModel())).id();
    }

    @Override
    public GalleryImageIdentifier identifier() {
        return ((GalleryImageInner)((Object)this.innerModel())).identifier();
    }

    @Override
    public String location() {
        return ((GalleryImageInner)((Object)this.innerModel())).location();
    }

    @Override
    public String name() {
        return ((GalleryImageInner)((Object)this.innerModel())).name();
    }

    @Override
    public OperatingSystemStateTypes osState() {
        return ((GalleryImageInner)((Object)this.innerModel())).osState();
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((GalleryImageInner)((Object)this.innerModel())).osType();
    }

    @Override
    public String privacyStatementUri() {
        return ((GalleryImageInner)((Object)this.innerModel())).privacyStatementUri();
    }

    @Override
    public String provisioningState() {
        return ((GalleryImageInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public ImagePurchasePlan purchasePlan() {
        return ((GalleryImageInner)((Object)this.innerModel())).purchasePlan();
    }

    @Override
    public RecommendedMachineConfiguration recommendedVirtualMachineConfiguration() {
        return ((GalleryImageInner)((Object)this.innerModel())).recommended();
    }

    @Override
    public String releaseNoteUri() {
        return ((GalleryImageInner)((Object)this.innerModel())).releaseNoteUri();
    }

    @Override
    public Map<String, String> tags() {
        return ((GalleryImageInner)((Object)this.innerModel())).tags();
    }

    @Override
    public String type() {
        return ((GalleryImageInner)((Object)this.innerModel())).type();
    }

    @Override
    public GalleryImageImpl withExistingGallery(String resourceGroupName, String galleryName) {
        this.resourceGroupName = resourceGroupName;
        this.galleryName = galleryName;
        return this;
    }

    @Override
    public GalleryImageImpl withExistingGallery(Gallery gallery) {
        this.resourceGroupName = gallery.resourceGroupName();
        this.galleryName = gallery.name();
        return this;
    }

    @Override
    public GalleryImageImpl withLocation(String location) {
        ((GalleryImageInner)((Object)this.innerModel())).withLocation(location);
        return this;
    }

    @Override
    public GalleryImageImpl withLocation(Region location) {
        ((GalleryImageInner)((Object)this.innerModel())).withLocation(location.toString());
        return this;
    }

    @Override
    public GalleryImageImpl withIdentifier(GalleryImageIdentifier identifier) {
        ((GalleryImageInner)((Object)this.innerModel())).withIdentifier(identifier);
        return this;
    }

    @Override
    public GalleryImageImpl withIdentifier(String publisher, String offer, String sku) {
        ((GalleryImageInner)((Object)this.innerModel())).withIdentifier(new GalleryImageIdentifier().withPublisher(publisher).withOffer(offer).withSku(sku));
        return this;
    }

    @Override
    public GalleryImageImpl withGeneralizedWindows() {
        return this.withWindows(OperatingSystemStateTypes.GENERALIZED);
    }

    @Override
    public GalleryImageImpl withGeneralizedLinux() {
        return this.withLinux(OperatingSystemStateTypes.GENERALIZED);
    }

    @Override
    public GalleryImageImpl withWindows(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withOsState(osState);
        return this;
    }

    @Override
    public GalleryImageImpl withLinux(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withOsState(osState);
        return this;
    }

    @Override
    public GalleryImageImpl withDescription(String description) {
        ((GalleryImageInner)((Object)this.innerModel())).withDescription(description);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withDescription(description);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withUnsupportedDiskType(DiskSkuTypes diskType) {
        if (((GalleryImageInner)((Object)this.innerModel())).disallowed() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withDisallowed(new Disallowed());
        }
        if (((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).disallowed().withDiskTypes(new ArrayList<String>());
        }
        boolean found = false;
        String newDiskTypeStr = diskType.toString();
        for (String diskTypeStr : ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes()) {
            if (!diskTypeStr.equalsIgnoreCase(newDiskTypeStr)) continue;
            found = true;
            break;
        }
        if (!found) {
            ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes().add(diskType.toString());
        }
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withDisallowed(((GalleryImageInner)((Object)this.innerModel())).disallowed());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withUnsupportedDiskTypes(List<DiskSkuTypes> diskTypes) {
        if (((GalleryImageInner)((Object)this.innerModel())).disallowed() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withDisallowed(new Disallowed());
        }
        ((GalleryImageInner)((Object)this.innerModel())).disallowed().withDiskTypes(new ArrayList<String>());
        for (DiskSkuTypes diskType : diskTypes) {
            ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes().add(diskType.toString());
        }
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withDisallowed(((GalleryImageInner)((Object)this.innerModel())).disallowed());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withoutUnsupportedDiskType(DiskSkuTypes diskType) {
        if (((GalleryImageInner)((Object)this.innerModel())).disallowed() != null && ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes() != null) {
            int foundIndex = -1;
            int i = 0;
            String diskTypeToRemove = diskType.toString();
            for (String diskTypeStr : ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes()) {
                if (diskTypeStr.equalsIgnoreCase(diskTypeToRemove)) {
                    foundIndex = i;
                    break;
                }
                ++i;
            }
            if (foundIndex != -1) {
                ((GalleryImageInner)((Object)this.innerModel())).disallowed().diskTypes().remove(foundIndex);
            }
            if (this.isInUpdateMode()) {
                this.galleryImageUpdate.withDisallowed(((GalleryImageInner)((Object)this.innerModel())).disallowed());
            }
        }
        return this;
    }

    @Override
    public GalleryImageImpl withDisallowed(Disallowed disallowed) {
        ((GalleryImageInner)((Object)this.innerModel())).withDisallowed(disallowed);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withDisallowed(disallowed);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        ((GalleryImageInner)((Object)this.innerModel())).withEndOfLifeDate(endOfLifeDate);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withEndOfLifeDate(endOfLifeDate);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withEula(String eula) {
        ((GalleryImageInner)((Object)this.innerModel())).withEula(eula);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withEula(eula);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withOsState(OperatingSystemStateTypes osState) {
        ((GalleryImageInner)((Object)this.innerModel())).withOsState(osState);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withOsState(osState);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withPrivacyStatementUri(String privacyStatementUri) {
        ((GalleryImageInner)((Object)this.innerModel())).withPrivacyStatementUri(privacyStatementUri);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withPrivacyStatementUri(privacyStatementUri);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withPurchasePlan(String name, String publisher, String product) {
        return this.withPurchasePlan(new ImagePurchasePlan().withName(name).withPublisher(publisher).withProduct(product));
    }

    @Override
    public GalleryImageImpl withPurchasePlan(ImagePurchasePlan purchasePlan) {
        ((GalleryImageInner)((Object)this.innerModel())).withPurchasePlan(purchasePlan);
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMinimumCPUsCountForVirtualMachine(int minCount) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).recommended().withVCPUs(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs().withMin(minCount);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMaximumCPUsCountForVirtualMachine(int maxCount) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).recommended().withVCPUs(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs().withMax(maxCount);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedCPUsCountForVirtualMachine(int minCount, int maxCount) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().withVCPUs(new ResourceRange());
        ((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs().withMin(minCount);
        ((GalleryImageInner)((Object)this.innerModel())).recommended().vCPUs().withMax(maxCount);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMinimumMemoryForVirtualMachine(int minMB) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.innerModel())).recommended().memory() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).recommended().withMemory(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().memory().withMin(minMB);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMaximumMemoryForVirtualMachine(int maxMB) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        if (((GalleryImageInner)((Object)this.innerModel())).recommended().memory() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).recommended().withMemory(new ResourceRange());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().memory().withMax(maxMB);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedMemoryForVirtualMachine(int minMB, int maxMB) {
        if (((GalleryImageInner)((Object)this.innerModel())).recommended() == null) {
            ((GalleryImageInner)((Object)this.innerModel())).withRecommended(new RecommendedMachineConfiguration());
        }
        ((GalleryImageInner)((Object)this.innerModel())).recommended().withMemory(new ResourceRange());
        ((GalleryImageInner)((Object)this.innerModel())).recommended().memory().withMin(minMB);
        ((GalleryImageInner)((Object)this.innerModel())).recommended().memory().withMax(maxMB);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(((GalleryImageInner)((Object)this.innerModel())).recommended());
        }
        return this;
    }

    @Override
    public GalleryImageImpl withRecommendedConfigurationForVirtualMachine(RecommendedMachineConfiguration recommendedConfig) {
        ((GalleryImageInner)((Object)this.innerModel())).withRecommended(recommendedConfig);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withRecommended(recommendedConfig);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withReleaseNoteUri(String releaseNoteUri) {
        ((GalleryImageInner)((Object)this.innerModel())).withReleaseNoteUri(releaseNoteUri);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withReleaseNoteUri(releaseNoteUri);
        }
        return this;
    }

    @Override
    public GalleryImageImpl withTags(Map<String, String> tags) {
        ((GalleryImageInner)((Object)this.innerModel())).withTags((Map)tags);
        if (this.isInUpdateMode()) {
            this.galleryImageUpdate.withTags((Map)tags);
        }
        return this;
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    private static String getValueFromIdByName(String id, String name) {
        if (id == null) {
            return null;
        }
        List<String> iterable = Arrays.asList(id.split("/"));
        Iterator itr = iterable.iterator();
        while (itr.hasNext()) {
            String part = (String)itr.next();
            if (part == null || part.trim().isEmpty() || !part.equalsIgnoreCase(name)) continue;
            if (itr.hasNext()) {
                return (String)itr.next();
            }
            return null;
        }
        return null;
    }
}

