/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class DiskRestorePointProperties {
    @JsonProperty(value="timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="sourceResourceId", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceId;
    @JsonProperty(value="osType", access=JsonProperty.Access.WRITE_ONLY)
    private OperatingSystemTypes osType;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="supportedCapabilities")
    private SupportedCapabilities supportedCapabilities;
    @JsonProperty(value="familyId", access=JsonProperty.Access.WRITE_ONLY)
    private String familyId;
    @JsonProperty(value="sourceUniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceUniqueId;
    @JsonProperty(value="encryption", access=JsonProperty.Access.WRITE_ONLY)
    private Encryption encryption;
    @JsonProperty(value="supportsHibernation")
    private Boolean supportsHibernation;
    @JsonProperty(value="networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="completionPercent")
    private Float completionPercent;
    @JsonProperty(value="replicationState", access=JsonProperty.Access.WRITE_ONLY)
    private String replicationState;
    @JsonProperty(value="sourceResourceLocation", access=JsonProperty.Access.WRITE_ONLY)
    private String sourceResourceLocation;
    @JsonProperty(value="securityProfile")
    private DiskSecurityProfile securityProfile;
    @JsonProperty(value="logicalSectorSize", access=JsonProperty.Access.WRITE_ONLY)
    private Integer logicalSectorSize;

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskRestorePointProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskRestorePointProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public DiskRestorePointProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public String familyId() {
        return this.familyId;
    }

    public String sourceUniqueId() {
        return this.sourceUniqueId;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskRestorePointProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskRestorePointProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DiskRestorePointProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskRestorePointProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public DiskRestorePointProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public String replicationState() {
        return this.replicationState;
    }

    public String sourceResourceLocation() {
        return this.sourceResourceLocation;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public DiskRestorePointProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Integer logicalSectorSize() {
        return this.logicalSectorSize;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }
}

