/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetInner;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;

public interface DiskEncryptionSet
extends GroupableResource<ComputeManager, DiskEncryptionSetInner>,
Updatable<Update>,
Refreshable<DiskEncryptionSet> {
    public String keyVaultId();

    public String encryptionKeyId();

    public String systemAssignedManagedServiceIdentityPrincipalId();

    public Boolean isAutomaticKeyRotationEnabled();

    public DiskEncryptionSetType encryptionType();

    public static interface UpdateStages {

        public static interface WithAutomaticKeyRotation {
            public Update withAutomaticKeyRotation();

            public Update withoutAutomaticKeyRotation();
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public Update withSystemAssignedManagedServiceIdentity();

            public Update withoutSystemAssignedManagedServiceIdentity();
        }
    }

    public static interface Update
    extends Appliable<DiskEncryptionSet>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSystemAssignedManagedServiceIdentity,
    UpdateStages.WithAutomaticKeyRotation {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<DiskEncryptionSet>,
        Resource.DefinitionWithTags<WithCreate>,
        WithAutomaticKeyRotation {
        }

        public static interface WithAutomaticKeyRotation {
            public WithCreate withAutomaticKeyRotation();
        }

        public static interface WithSystemAssignedIdentityBasedAccessOrCreate
        extends WithCreate {
            public WithCreate withRoleBasedAccessToCurrentKeyVault(BuiltInRole var1);

            public WithCreate withRoleBasedAccessToCurrentKeyVault();
        }

        public static interface WithSystemAssignedManagedServiceIdentity {
            public WithSystemAssignedIdentityBasedAccessOrCreate withSystemAssignedManagedServiceIdentity();
        }

        public static interface WithKeyVaultKey {
            public WithSystemAssignedManagedServiceIdentity withExistingKey(String var1);
        }

        public static interface WithKeyVault {
            public WithKeyVaultKey withExistingKeyVault(String var1);
        }

        public static interface WithEncryptionType {
            public WithKeyVault withEncryptionType(DiskEncryptionSetType var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithEncryptionType> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithEncryptionType,
    DefinitionStages.WithKeyVault,
    DefinitionStages.WithKeyVaultKey,
    DefinitionStages.WithSystemAssignedManagedServiceIdentity,
    DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
    DefinitionStages.WithCreate {
    }
}

