/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.ImageDisk;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImageOSDisk
extends ImageDisk {
    @JsonProperty(value="osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="osState", required=true)
    private OperatingSystemStateTypes osState;
    private static final ClientLogger LOGGER = new ClientLogger(ImageOSDisk.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public ImageOSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public ImageOSDisk withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    @Override
    public ImageOSDisk withSnapshot(SubResource snapshot) {
        super.withSnapshot(snapshot);
        return this;
    }

    @Override
    public ImageOSDisk withManagedDisk(SubResource managedDisk) {
        super.withManagedDisk(managedDisk);
        return this;
    }

    @Override
    public ImageOSDisk withBlobUri(String blobUri) {
        super.withBlobUri(blobUri);
        return this;
    }

    @Override
    public ImageOSDisk withCaching(CachingTypes caching) {
        super.withCaching(caching);
        return this;
    }

    @Override
    public ImageOSDisk withDiskSizeGB(Integer diskSizeGB) {
        super.withDiskSizeGB(diskSizeGB);
        return this;
    }

    @Override
    public ImageOSDisk withStorageAccountType(StorageAccountTypes storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public ImageOSDisk withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        super.withDiskEncryptionSet(diskEncryptionSet);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model ImageOSDisk"));
        }
        if (this.osState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osState in model ImageOSDisk"));
        }
    }
}

