/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GalleryImageProperties
implements JsonSerializable<GalleryImageProperties> {
    private String description;
    private String eula;
    private String privacyStatementUri;
    private String releaseNoteUri;
    private OperatingSystemTypes osType;
    private OperatingSystemStateTypes osState;
    private HyperVGeneration hyperVGeneration;
    private OffsetDateTime endOfLifeDate;
    private GalleryImageIdentifier identifier;
    private RecommendedMachineConfiguration recommended;
    private Disallowed disallowed;
    private ImagePurchasePlan purchasePlan;
    private GalleryProvisioningState provisioningState;
    private List<GalleryImageFeature> features;
    private Architecture architecture;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageProperties.class);

    public String description() {
        return this.description;
    }

    public GalleryImageProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryImageProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public GalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public GalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public GalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public GalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public GalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public GalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public GalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public GalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public GalleryImageProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model GalleryImageProperties"));
        }
        if (this.osState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osState in model GalleryImageProperties"));
        }
        if (this.identifier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identifier in model GalleryImageProperties"));
        }
        this.identifier().validate();
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osState", this.osState == null ? null : this.osState.toString());
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.identifier);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("releaseNoteUri", this.releaseNoteUri);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeJsonField("recommended", (JsonSerializable)this.recommended);
        jsonWriter.writeJsonField("disallowed", (JsonSerializable)this.disallowed);
        jsonWriter.writeJsonField("purchasePlan", (JsonSerializable)this.purchasePlan);
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageProperties)jsonReader.readObject(reader -> {
            GalleryImageProperties deserializedGalleryImageProperties = new GalleryImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedGalleryImageProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("osState".equals(fieldName)) {
                    deserializedGalleryImageProperties.osState = OperatingSystemStateTypes.fromString(reader.getString());
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedGalleryImageProperties.identifier = GalleryImageIdentifier.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryImageProperties.description = reader.getString();
                    continue;
                }
                if ("eula".equals(fieldName)) {
                    deserializedGalleryImageProperties.eula = reader.getString();
                    continue;
                }
                if ("privacyStatementUri".equals(fieldName)) {
                    deserializedGalleryImageProperties.privacyStatementUri = reader.getString();
                    continue;
                }
                if ("releaseNoteUri".equals(fieldName)) {
                    deserializedGalleryImageProperties.releaseNoteUri = reader.getString();
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedGalleryImageProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryImageProperties.endOfLifeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recommended".equals(fieldName)) {
                    deserializedGalleryImageProperties.recommended = RecommendedMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("disallowed".equals(fieldName)) {
                    deserializedGalleryImageProperties.disallowed = Disallowed.fromJson(reader);
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedGalleryImageProperties.purchasePlan = ImagePurchasePlan.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryImageProperties.provisioningState = GalleryProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedGalleryImageProperties.features = features = reader.readArray(reader1 -> GalleryImageFeature.fromJson(reader1));
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedGalleryImageProperties.architecture = Architecture.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageProperties;
        });
    }
}

