/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryIdentifier;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryProperties;
import com.azure.resourcemanager.compute.models.PirSharedGalleryResource;
import java.io.IOException;
import java.util.Map;

public final class SharedGalleryInner
extends PirSharedGalleryResource {
    private SharedGalleryProperties innerProperties;
    private String name;
    private String location;
    private SharedGalleryIdentifier innerIdentifier;

    private SharedGalleryProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    private SharedGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    @Override
    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    @Override
    public SharedGalleryInner withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new SharedGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.innerProperties() == null ? null : this.innerProperties().artifactTags();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.innerIdentifier());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryInner fromJson(JsonReader jsonReader) throws IOException {
        return (SharedGalleryInner)jsonReader.readObject(reader -> {
            SharedGalleryInner deserializedSharedGalleryInner = new SharedGalleryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSharedGalleryInner.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSharedGalleryInner.location = reader.getString();
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedSharedGalleryInner.innerIdentifier = SharedGalleryIdentifier.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSharedGalleryInner.innerProperties = SharedGalleryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryInner;
        });
    }
}

