/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliaryMode;
import com.azure.resourcemanager.compute.models.NetworkInterfaceAuxiliarySku;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceDnsSettingsConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineNetworkInterfaceIpConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineNetworkInterfaceConfigurationProperties
implements JsonSerializable<VirtualMachineNetworkInterfaceConfigurationProperties> {
    private Boolean primary;
    private DeleteOptions deleteOption;
    private Boolean enableAcceleratedNetworking;
    private Boolean disableTcpStateTracking;
    private Boolean enableFpga;
    private Boolean enableIpForwarding;
    private SubResource networkSecurityGroup;
    private VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings;
    private List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations;
    private SubResource dscpConfiguration;
    private NetworkInterfaceAuxiliaryMode auxiliaryMode;
    private NetworkInterfaceAuxiliarySku auxiliarySku;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineNetworkInterfaceConfigurationProperties.class);

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public DeleteOptions deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withDeleteOption(DeleteOptions deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public Boolean enableAcceleratedNetworking() {
        return this.enableAcceleratedNetworking;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withEnableAcceleratedNetworking(Boolean enableAcceleratedNetworking) {
        this.enableAcceleratedNetworking = enableAcceleratedNetworking;
        return this;
    }

    public Boolean disableTcpStateTracking() {
        return this.disableTcpStateTracking;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withDisableTcpStateTracking(Boolean disableTcpStateTracking) {
        this.disableTcpStateTracking = disableTcpStateTracking;
        return this;
    }

    public Boolean enableFpga() {
        return this.enableFpga;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withEnableFpga(Boolean enableFpga) {
        this.enableFpga = enableFpga;
        return this;
    }

    public Boolean enableIpForwarding() {
        return this.enableIpForwarding;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withEnableIpForwarding(Boolean enableIpForwarding) {
        this.enableIpForwarding = enableIpForwarding;
        return this;
    }

    public SubResource networkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withNetworkSecurityGroup(SubResource networkSecurityGroup) {
        this.networkSecurityGroup = networkSecurityGroup;
        return this;
    }

    public VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings() {
        return this.dnsSettings;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withDnsSettings(VirtualMachineNetworkInterfaceDnsSettingsConfiguration dnsSettings) {
        this.dnsSettings = dnsSettings;
        return this;
    }

    public List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withIpConfigurations(List<VirtualMachineNetworkInterfaceIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    public SubResource dscpConfiguration() {
        return this.dscpConfiguration;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withDscpConfiguration(SubResource dscpConfiguration) {
        this.dscpConfiguration = dscpConfiguration;
        return this;
    }

    public NetworkInterfaceAuxiliaryMode auxiliaryMode() {
        return this.auxiliaryMode;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withAuxiliaryMode(NetworkInterfaceAuxiliaryMode auxiliaryMode) {
        this.auxiliaryMode = auxiliaryMode;
        return this;
    }

    public NetworkInterfaceAuxiliarySku auxiliarySku() {
        return this.auxiliarySku;
    }

    public VirtualMachineNetworkInterfaceConfigurationProperties withAuxiliarySku(NetworkInterfaceAuxiliarySku auxiliarySku) {
        this.auxiliarySku = auxiliarySku;
        return this;
    }

    public void validate() {
        if (this.dnsSettings() != null) {
            this.dnsSettings().validate();
        }
        if (this.ipConfigurations() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipConfigurations in model VirtualMachineNetworkInterfaceConfigurationProperties"));
        }
        this.ipConfigurations().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("primary", this.primary);
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        jsonWriter.writeBooleanField("enableAcceleratedNetworking", this.enableAcceleratedNetworking);
        jsonWriter.writeBooleanField("disableTcpStateTracking", this.disableTcpStateTracking);
        jsonWriter.writeBooleanField("enableFpga", this.enableFpga);
        jsonWriter.writeBooleanField("enableIPForwarding", this.enableIpForwarding);
        jsonWriter.writeJsonField("networkSecurityGroup", (JsonSerializable)this.networkSecurityGroup);
        jsonWriter.writeJsonField("dnsSettings", (JsonSerializable)this.dnsSettings);
        jsonWriter.writeJsonField("dscpConfiguration", (JsonSerializable)this.dscpConfiguration);
        jsonWriter.writeStringField("auxiliaryMode", this.auxiliaryMode == null ? null : this.auxiliaryMode.toString());
        jsonWriter.writeStringField("auxiliarySku", this.auxiliarySku == null ? null : this.auxiliarySku.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineNetworkInterfaceConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineNetworkInterfaceConfigurationProperties)jsonReader.readObject(reader -> {
            VirtualMachineNetworkInterfaceConfigurationProperties deserializedVirtualMachineNetworkInterfaceConfigurationProperties = new VirtualMachineNetworkInterfaceConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ipConfigurations".equals(fieldName)) {
                    List ipConfigurations;
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.ipConfigurations = ipConfigurations = reader.readArray(reader1 -> VirtualMachineNetworkInterfaceIpConfiguration.fromJson(reader1));
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deleteOption".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.deleteOption = DeleteOptions.fromString(reader.getString());
                    continue;
                }
                if ("enableAcceleratedNetworking".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.enableAcceleratedNetworking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("disableTcpStateTracking".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.disableTcpStateTracking = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableFpga".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.enableFpga = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableIPForwarding".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.enableIpForwarding = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("networkSecurityGroup".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.networkSecurityGroup = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("dnsSettings".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.dnsSettings = VirtualMachineNetworkInterfaceDnsSettingsConfiguration.fromJson(reader);
                    continue;
                }
                if ("dscpConfiguration".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.dscpConfiguration = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("auxiliaryMode".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.auxiliaryMode = NetworkInterfaceAuxiliaryMode.fromString(reader.getString());
                    continue;
                }
                if ("auxiliarySku".equals(fieldName)) {
                    deserializedVirtualMachineNetworkInterfaceConfigurationProperties.auxiliarySku = NetworkInterfaceAuxiliarySku.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineNetworkInterfaceConfigurationProperties;
        });
    }
}

