/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.PriorityMixPolicy;
import com.azure.resourcemanager.compute.models.ResiliencyPolicy;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.SkuProfile;
import com.azure.resourcemanager.compute.models.SpotRestorePolicy;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateVMProfile;
import com.azure.resourcemanager.compute.models.ZonalPlatformFaultDomainAlignMode;
import java.io.IOException;

public final class VirtualMachineScaleSetUpdateProperties
implements JsonSerializable<VirtualMachineScaleSetUpdateProperties> {
    private UpgradePolicy upgradePolicy;
    private AutomaticRepairsPolicy automaticRepairsPolicy;
    private VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile;
    private Boolean overprovision;
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    private Boolean singlePlacementGroup;
    private AdditionalCapabilities additionalCapabilities;
    private ScaleInPolicy scaleInPolicy;
    private SubResource proximityPlacementGroup;
    private PriorityMixPolicy priorityMixPolicy;
    private SpotRestorePolicy spotRestorePolicy;
    private ResiliencyPolicy resiliencyPolicy;
    private ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode;
    private SkuProfile skuProfile;

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.automaticRepairsPolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        this.automaticRepairsPolicy = automaticRepairsPolicy;
        return this;
    }

    public VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile() {
        return this.virtualMachineProfile;
    }

    public VirtualMachineScaleSetUpdateProperties withVirtualMachineProfile(VirtualMachineScaleSetUpdateVMProfile virtualMachineProfile) {
        this.virtualMachineProfile = virtualMachineProfile;
        return this;
    }

    public Boolean overprovision() {
        return this.overprovision;
    }

    public VirtualMachineScaleSetUpdateProperties withOverprovision(Boolean overprovision) {
        this.overprovision = overprovision;
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    public VirtualMachineScaleSetUpdateProperties withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        this.doNotRunExtensionsOnOverprovisionedVMs = doNotRunExtensionsOnOverprovisionedVMs;
        return this;
    }

    public Boolean singlePlacementGroup() {
        return this.singlePlacementGroup;
    }

    public VirtualMachineScaleSetUpdateProperties withSinglePlacementGroup(Boolean singlePlacementGroup) {
        this.singlePlacementGroup = singlePlacementGroup;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetUpdateProperties withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        this.scaleInPolicy = scaleInPolicy;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineScaleSetUpdateProperties withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public PriorityMixPolicy priorityMixPolicy() {
        return this.priorityMixPolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withPriorityMixPolicy(PriorityMixPolicy priorityMixPolicy) {
        this.priorityMixPolicy = priorityMixPolicy;
        return this;
    }

    public SpotRestorePolicy spotRestorePolicy() {
        return this.spotRestorePolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withSpotRestorePolicy(SpotRestorePolicy spotRestorePolicy) {
        this.spotRestorePolicy = spotRestorePolicy;
        return this;
    }

    public ResiliencyPolicy resiliencyPolicy() {
        return this.resiliencyPolicy;
    }

    public VirtualMachineScaleSetUpdateProperties withResiliencyPolicy(ResiliencyPolicy resiliencyPolicy) {
        this.resiliencyPolicy = resiliencyPolicy;
        return this;
    }

    public ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode() {
        return this.zonalPlatformFaultDomainAlignMode;
    }

    public VirtualMachineScaleSetUpdateProperties withZonalPlatformFaultDomainAlignMode(ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode) {
        this.zonalPlatformFaultDomainAlignMode = zonalPlatformFaultDomainAlignMode;
        return this;
    }

    public SkuProfile skuProfile() {
        return this.skuProfile;
    }

    public VirtualMachineScaleSetUpdateProperties withSkuProfile(SkuProfile skuProfile) {
        this.skuProfile = skuProfile;
        return this;
    }

    public void validate() {
        if (this.upgradePolicy() != null) {
            this.upgradePolicy().validate();
        }
        if (this.automaticRepairsPolicy() != null) {
            this.automaticRepairsPolicy().validate();
        }
        if (this.virtualMachineProfile() != null) {
            this.virtualMachineProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.scaleInPolicy() != null) {
            this.scaleInPolicy().validate();
        }
        if (this.priorityMixPolicy() != null) {
            this.priorityMixPolicy().validate();
        }
        if (this.spotRestorePolicy() != null) {
            this.spotRestorePolicy().validate();
        }
        if (this.resiliencyPolicy() != null) {
            this.resiliencyPolicy().validate();
        }
        if (this.skuProfile() != null) {
            this.skuProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("upgradePolicy", (JsonSerializable)this.upgradePolicy);
        jsonWriter.writeJsonField("automaticRepairsPolicy", (JsonSerializable)this.automaticRepairsPolicy);
        jsonWriter.writeJsonField("virtualMachineProfile", (JsonSerializable)this.virtualMachineProfile);
        jsonWriter.writeBooleanField("overprovision", this.overprovision);
        jsonWriter.writeBooleanField("doNotRunExtensionsOnOverprovisionedVMs", this.doNotRunExtensionsOnOverprovisionedVMs);
        jsonWriter.writeBooleanField("singlePlacementGroup", this.singlePlacementGroup);
        jsonWriter.writeJsonField("additionalCapabilities", (JsonSerializable)this.additionalCapabilities);
        jsonWriter.writeJsonField("scaleInPolicy", (JsonSerializable)this.scaleInPolicy);
        jsonWriter.writeJsonField("proximityPlacementGroup", (JsonSerializable)this.proximityPlacementGroup);
        jsonWriter.writeJsonField("priorityMixPolicy", (JsonSerializable)this.priorityMixPolicy);
        jsonWriter.writeJsonField("spotRestorePolicy", (JsonSerializable)this.spotRestorePolicy);
        jsonWriter.writeJsonField("resiliencyPolicy", (JsonSerializable)this.resiliencyPolicy);
        jsonWriter.writeStringField("zonalPlatformFaultDomainAlignMode", this.zonalPlatformFaultDomainAlignMode == null ? null : this.zonalPlatformFaultDomainAlignMode.toString());
        jsonWriter.writeJsonField("skuProfile", (JsonSerializable)this.skuProfile);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdateProperties)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateProperties deserializedVirtualMachineScaleSetUpdateProperties = new VirtualMachineScaleSetUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("upgradePolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.upgradePolicy = UpgradePolicy.fromJson(reader);
                    continue;
                }
                if ("automaticRepairsPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.automaticRepairsPolicy = AutomaticRepairsPolicy.fromJson(reader);
                    continue;
                }
                if ("virtualMachineProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.virtualMachineProfile = VirtualMachineScaleSetUpdateVMProfile.fromJson(reader);
                    continue;
                }
                if ("overprovision".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.overprovision = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("doNotRunExtensionsOnOverprovisionedVMs".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.doNotRunExtensionsOnOverprovisionedVMs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("singlePlacementGroup".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.singlePlacementGroup = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("additionalCapabilities".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.additionalCapabilities = AdditionalCapabilities.fromJson(reader);
                    continue;
                }
                if ("scaleInPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.scaleInPolicy = ScaleInPolicy.fromJson(reader);
                    continue;
                }
                if ("proximityPlacementGroup".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.proximityPlacementGroup = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("priorityMixPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.priorityMixPolicy = PriorityMixPolicy.fromJson(reader);
                    continue;
                }
                if ("spotRestorePolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.spotRestorePolicy = SpotRestorePolicy.fromJson(reader);
                    continue;
                }
                if ("resiliencyPolicy".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.resiliencyPolicy = ResiliencyPolicy.fromJson(reader);
                    continue;
                }
                if ("zonalPlatformFaultDomainAlignMode".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.zonalPlatformFaultDomainAlignMode = ZonalPlatformFaultDomainAlignMode.fromString(reader.getString());
                    continue;
                }
                if ("skuProfile".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateProperties.skuProfile = SkuProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdateProperties;
        });
    }
}

