/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryIdentifier;
import com.azure.resourcemanager.compute.models.PirResource;
import java.io.IOException;

public class PirSharedGalleryResource
extends PirResource {
    private SharedGalleryIdentifier innerIdentifier;
    private String name;
    private String location;

    private SharedGalleryIdentifier innerIdentifier() {
        return this.innerIdentifier;
    }

    PirSharedGalleryResource withInnerIdentifier(SharedGalleryIdentifier innerIdentifier) {
        this.innerIdentifier = innerIdentifier;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    public String uniqueId() {
        return this.innerIdentifier() == null ? null : this.innerIdentifier().uniqueId();
    }

    public PirSharedGalleryResource withUniqueId(String uniqueId) {
        if (this.innerIdentifier() == null) {
            this.innerIdentifier = new SharedGalleryIdentifier();
        }
        this.innerIdentifier().withUniqueId(uniqueId);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerIdentifier() != null) {
            this.innerIdentifier().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.innerIdentifier);
        return jsonWriter.writeEndObject();
    }

    public static PirSharedGalleryResource fromJson(JsonReader jsonReader) throws IOException {
        return (PirSharedGalleryResource)jsonReader.readObject(reader -> {
            PirSharedGalleryResource deserializedPirSharedGalleryResource = new PirSharedGalleryResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedPirSharedGalleryResource.name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedPirSharedGalleryResource.location = reader.getString();
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedPirSharedGalleryResource.innerIdentifier = SharedGalleryIdentifier.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPirSharedGalleryResource;
        });
    }
}

