/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetListWithLinkResult
implements JsonSerializable<VirtualMachineScaleSetListWithLinkResult> {
    private List<VirtualMachineScaleSetInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetListWithLinkResult.class);

    public List<VirtualMachineScaleSetInner> value() {
        return this.value;
    }

    public VirtualMachineScaleSetListWithLinkResult withValue(List<VirtualMachineScaleSetInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualMachineScaleSetListWithLinkResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model VirtualMachineScaleSetListWithLinkResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetListWithLinkResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetListWithLinkResult)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetListWithLinkResult deserializedVirtualMachineScaleSetListWithLinkResult = new VirtualMachineScaleSetListWithLinkResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineScaleSetListWithLinkResult.value = value = reader.readArray(reader1 -> VirtualMachineScaleSetInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetListWithLinkResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetListWithLinkResult;
        });
    }
}

