/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceRoleProperties;
import com.azure.resourcemanager.compute.models.CloudServiceRoleSku;
import java.io.IOException;

public final class CloudServiceRoleInner
implements JsonSerializable<CloudServiceRoleInner> {
    private String id;
    private String name;
    private String type;
    private String location;
    private CloudServiceRoleSku sku;
    private CloudServiceRoleProperties properties;

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String location() {
        return this.location;
    }

    public CloudServiceRoleSku sku() {
        return this.sku;
    }

    public CloudServiceRoleInner withSku(CloudServiceRoleSku sku) {
        this.sku = sku;
        return this;
    }

    public CloudServiceRoleProperties properties() {
        return this.properties;
    }

    public CloudServiceRoleInner withProperties(CloudServiceRoleProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceRoleInner fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceRoleInner)jsonReader.readObject(reader -> {
            CloudServiceRoleInner deserializedCloudServiceRoleInner = new CloudServiceRoleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.location = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.sku = CloudServiceRoleSku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCloudServiceRoleInner.properties = CloudServiceRoleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceRoleInner;
        });
    }
}

