/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RollingUpgradeStatusInfoProperties;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.RollingUpgradePolicy;
import com.azure.resourcemanager.compute.models.RollingUpgradeProgressInfo;
import com.azure.resourcemanager.compute.models.RollingUpgradeRunningStatus;
import java.io.IOException;
import java.util.Map;

public final class RollingUpgradeStatusInfoInner
extends Resource {
    private RollingUpgradeStatusInfoProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private RollingUpgradeStatusInfoProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public RollingUpgradeStatusInfoInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RollingUpgradeStatusInfoInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public RollingUpgradePolicy policy() {
        return this.innerProperties() == null ? null : this.innerProperties().policy();
    }

    public RollingUpgradeRunningStatus runningStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().runningStatus();
    }

    public RollingUpgradeProgressInfo progress() {
        return this.innerProperties() == null ? null : this.innerProperties().progress();
    }

    public ApiError error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RollingUpgradeStatusInfoInner fromJson(JsonReader jsonReader) throws IOException {
        return (RollingUpgradeStatusInfoInner)((Object)jsonReader.readObject(reader -> {
            RollingUpgradeStatusInfoInner deserializedRollingUpgradeStatusInfoInner = new RollingUpgradeStatusInfoInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRollingUpgradeStatusInfoInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRollingUpgradeStatusInfoInner.innerProperties = RollingUpgradeStatusInfoProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRollingUpgradeStatusInfoInner;
        }));
    }
}

