/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageProperties;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.azure.resourcemanager.compute.models.UpdateResourceDefinition;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class GalleryImageUpdate
extends UpdateResourceDefinition {
    private GalleryImageProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private GalleryImageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public GalleryImageUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public GalleryImageUpdate withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public String eula() {
        return this.innerProperties() == null ? null : this.innerProperties().eula();
    }

    public GalleryImageUpdate withEula(String eula) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withEula(eula);
        return this;
    }

    public String privacyStatementUri() {
        return this.innerProperties() == null ? null : this.innerProperties().privacyStatementUri();
    }

    public GalleryImageUpdate withPrivacyStatementUri(String privacyStatementUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withPrivacyStatementUri(privacyStatementUri);
        return this;
    }

    public String releaseNoteUri() {
        return this.innerProperties() == null ? null : this.innerProperties().releaseNoteUri();
    }

    public GalleryImageUpdate withReleaseNoteUri(String releaseNoteUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withReleaseNoteUri(releaseNoteUri);
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public GalleryImageUpdate withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.innerProperties() == null ? null : this.innerProperties().osState();
    }

    public GalleryImageUpdate withOsState(OperatingSystemStateTypes osState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withOsState(osState);
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public GalleryImageUpdate withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.innerProperties() == null ? null : this.innerProperties().endOfLifeDate();
    }

    public GalleryImageUpdate withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.innerProperties() == null ? null : this.innerProperties().identifier();
    }

    public GalleryImageUpdate withIdentifier(GalleryImageIdentifier identifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withIdentifier(identifier);
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.innerProperties() == null ? null : this.innerProperties().recommended();
    }

    public GalleryImageUpdate withRecommended(RecommendedMachineConfiguration recommended) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withRecommended(recommended);
        return this;
    }

    public Disallowed disallowed() {
        return this.innerProperties() == null ? null : this.innerProperties().disallowed();
    }

    public GalleryImageUpdate withDisallowed(Disallowed disallowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withDisallowed(disallowed);
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.innerProperties() == null ? null : this.innerProperties().purchasePlan();
    }

    public GalleryImageUpdate withPurchasePlan(ImagePurchasePlan purchasePlan) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withPurchasePlan(purchasePlan);
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<GalleryImageFeature> features() {
        return this.innerProperties() == null ? null : this.innerProperties().features();
    }

    public GalleryImageUpdate withFeatures(List<GalleryImageFeature> features) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withFeatures(features);
        return this;
    }

    public Architecture architecture() {
        return this.innerProperties() == null ? null : this.innerProperties().architecture();
    }

    public GalleryImageUpdate withArchitecture(Architecture architecture) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryImageProperties();
        }
        this.innerProperties().withArchitecture(architecture);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageUpdate)((Object)jsonReader.readObject(reader -> {
            GalleryImageUpdate deserializedGalleryImageUpdate = new GalleryImageUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryImageUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryImageUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryImageUpdate.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryImageUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryImageUpdate.innerProperties = GalleryImageProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageUpdate;
        }));
    }
}

