/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ImageProperties;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import com.azure.resourcemanager.compute.models.UpdateResource;
import java.io.IOException;
import java.util.Map;

public final class ImageUpdate
extends UpdateResource {
    private ImageProperties innerProperties;

    private ImageProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public ImageUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource sourceVirtualMachine() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceVirtualMachine();
    }

    public ImageUpdate withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withSourceVirtualMachine(sourceVirtualMachine);
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ImageUpdate withStorageProfile(ImageStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public ImageUpdate withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ImageUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (ImageUpdate)jsonReader.readObject(reader -> {
            ImageUpdate deserializedImageUpdate = new ImageUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedImageUpdate.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedImageUpdate.innerProperties = ImageProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageUpdate;
        });
    }
}

