/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.LinuxPatchSettings;
import com.azure.resourcemanager.compute.models.SshConfiguration;
import java.io.IOException;

public final class LinuxConfiguration
implements JsonSerializable<LinuxConfiguration> {
    private Boolean disablePasswordAuthentication;
    private SshConfiguration ssh;
    private Boolean provisionVMAgent;
    private LinuxPatchSettings patchSettings;
    private Boolean enableVMAgentPlatformUpdates;

    public Boolean disablePasswordAuthentication() {
        return this.disablePasswordAuthentication;
    }

    public LinuxConfiguration withDisablePasswordAuthentication(Boolean disablePasswordAuthentication) {
        this.disablePasswordAuthentication = disablePasswordAuthentication;
        return this;
    }

    public SshConfiguration ssh() {
        return this.ssh;
    }

    public LinuxConfiguration withSsh(SshConfiguration ssh) {
        this.ssh = ssh;
        return this;
    }

    public Boolean provisionVMAgent() {
        return this.provisionVMAgent;
    }

    public LinuxConfiguration withProvisionVMAgent(Boolean provisionVMAgent) {
        this.provisionVMAgent = provisionVMAgent;
        return this;
    }

    public LinuxPatchSettings patchSettings() {
        return this.patchSettings;
    }

    public LinuxConfiguration withPatchSettings(LinuxPatchSettings patchSettings) {
        this.patchSettings = patchSettings;
        return this;
    }

    public Boolean enableVMAgentPlatformUpdates() {
        return this.enableVMAgentPlatformUpdates;
    }

    public LinuxConfiguration withEnableVMAgentPlatformUpdates(Boolean enableVMAgentPlatformUpdates) {
        this.enableVMAgentPlatformUpdates = enableVMAgentPlatformUpdates;
        return this;
    }

    public void validate() {
        if (this.ssh() != null) {
            this.ssh().validate();
        }
        if (this.patchSettings() != null) {
            this.patchSettings().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("disablePasswordAuthentication", this.disablePasswordAuthentication);
        jsonWriter.writeJsonField("ssh", (JsonSerializable)this.ssh);
        jsonWriter.writeBooleanField("provisionVMAgent", this.provisionVMAgent);
        jsonWriter.writeJsonField("patchSettings", (JsonSerializable)this.patchSettings);
        jsonWriter.writeBooleanField("enableVMAgentPlatformUpdates", this.enableVMAgentPlatformUpdates);
        return jsonWriter.writeEndObject();
    }

    public static LinuxConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LinuxConfiguration)jsonReader.readObject(reader -> {
            LinuxConfiguration deserializedLinuxConfiguration = new LinuxConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("disablePasswordAuthentication".equals(fieldName)) {
                    deserializedLinuxConfiguration.disablePasswordAuthentication = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ssh".equals(fieldName)) {
                    deserializedLinuxConfiguration.ssh = SshConfiguration.fromJson(reader);
                    continue;
                }
                if ("provisionVMAgent".equals(fieldName)) {
                    deserializedLinuxConfiguration.provisionVMAgent = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("patchSettings".equals(fieldName)) {
                    deserializedLinuxConfiguration.patchSettings = LinuxPatchSettings.fromJson(reader);
                    continue;
                }
                if ("enableVMAgentPlatformUpdates".equals(fieldName)) {
                    deserializedLinuxConfiguration.enableVMAgentPlatformUpdates = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinuxConfiguration;
        });
    }
}

