/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.RestorePointEncryptionType;
import java.io.IOException;

public final class RestorePointEncryption
implements JsonSerializable<RestorePointEncryption> {
    private DiskEncryptionSetParameters diskEncryptionSet;
    private RestorePointEncryptionType type;

    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    public RestorePointEncryption withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    public RestorePointEncryptionType type() {
        return this.type;
    }

    public RestorePointEncryption withType(RestorePointEncryptionType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static RestorePointEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointEncryption)jsonReader.readObject(reader -> {
            RestorePointEncryption deserializedRestorePointEncryption = new RestorePointEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedRestorePointEncryption.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestorePointEncryption.type = RestorePointEncryptionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointEncryption;
        });
    }
}

