/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.fluent.models.GremlinDatabaseGetProperties;
import com.azure.resourcemanager.cosmos.models.ArmResourceProperties;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseGetPropertiesOptions;
import com.azure.resourcemanager.cosmos.models.GremlinDatabaseGetPropertiesResource;
import java.io.IOException;
import java.util.Map;

public final class GremlinDatabaseGetResultsInner
extends ArmResourceProperties {
    private GremlinDatabaseGetProperties innerProperties;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(GremlinDatabaseGetResultsInner.class);

    private GremlinDatabaseGetProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GremlinDatabaseGetResultsInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public GremlinDatabaseGetResultsInner withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public GremlinDatabaseGetPropertiesResource resource() {
        return this.innerProperties() == null ? null : this.innerProperties().resource();
    }

    public GremlinDatabaseGetResultsInner withResource(GremlinDatabaseGetPropertiesResource resource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinDatabaseGetProperties();
        }
        this.innerProperties().withResource(resource);
        return this;
    }

    public GremlinDatabaseGetPropertiesOptions options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public GremlinDatabaseGetResultsInner withOptions(GremlinDatabaseGetPropertiesOptions options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GremlinDatabaseGetProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model GremlinDatabaseGetResultsInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GremlinDatabaseGetResultsInner fromJson(JsonReader jsonReader) throws IOException {
        return (GremlinDatabaseGetResultsInner)((Object)jsonReader.readObject(reader -> {
            GremlinDatabaseGetResultsInner deserializedGremlinDatabaseGetResultsInner = new GremlinDatabaseGetResultsInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGremlinDatabaseGetResultsInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGremlinDatabaseGetResultsInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGremlinDatabaseGetResultsInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGremlinDatabaseGetResultsInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGremlinDatabaseGetResultsInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGremlinDatabaseGetResultsInner.innerProperties = GremlinDatabaseGetProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGremlinDatabaseGetResultsInner;
        }));
    }
}

