/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ApiType;
import com.azure.resourcemanager.cosmos.models.RestorableLocationResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RestorableDatabaseAccountProperties
implements JsonSerializable<RestorableDatabaseAccountProperties> {
    private String accountName;
    private OffsetDateTime creationTime;
    private OffsetDateTime deletionTime;
    private OffsetDateTime oldestRestorableTime;
    private ApiType apiType;
    private List<RestorableLocationResource> restorableLocations;

    public String accountName() {
        return this.accountName;
    }

    public RestorableDatabaseAccountProperties withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public OffsetDateTime creationTime() {
        return this.creationTime;
    }

    public RestorableDatabaseAccountProperties withCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime deletionTime() {
        return this.deletionTime;
    }

    public RestorableDatabaseAccountProperties withDeletionTime(OffsetDateTime deletionTime) {
        this.deletionTime = deletionTime;
        return this;
    }

    public OffsetDateTime oldestRestorableTime() {
        return this.oldestRestorableTime;
    }

    public RestorableDatabaseAccountProperties withOldestRestorableTime(OffsetDateTime oldestRestorableTime) {
        this.oldestRestorableTime = oldestRestorableTime;
        return this;
    }

    public ApiType apiType() {
        return this.apiType;
    }

    public List<RestorableLocationResource> restorableLocations() {
        return this.restorableLocations;
    }

    public void validate() {
        if (this.restorableLocations() != null) {
            this.restorableLocations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("creationTime", this.creationTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationTime));
        jsonWriter.writeStringField("deletionTime", this.deletionTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletionTime));
        jsonWriter.writeStringField("oldestRestorableTime", this.oldestRestorableTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.oldestRestorableTime));
        return jsonWriter.writeEndObject();
    }

    public static RestorableDatabaseAccountProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RestorableDatabaseAccountProperties)jsonReader.readObject(reader -> {
            RestorableDatabaseAccountProperties deserializedRestorableDatabaseAccountProperties = new RestorableDatabaseAccountProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountProperties.accountName = reader.getString();
                    continue;
                }
                if ("creationTime".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountProperties.creationTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deletionTime".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountProperties.deletionTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("oldestRestorableTime".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountProperties.oldestRestorableTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiType".equals(fieldName)) {
                    deserializedRestorableDatabaseAccountProperties.apiType = ApiType.fromString(reader.getString());
                    continue;
                }
                if ("restorableLocations".equals(fieldName)) {
                    List restorableLocations;
                    deserializedRestorableDatabaseAccountProperties.restorableLocations = restorableLocations = reader.readArray(reader1 -> RestorableLocationResource.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorableDatabaseAccountProperties;
        });
    }
}

