/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AccountKeyMetadata;
import java.io.IOException;

public final class DatabaseAccountKeysMetadata
implements JsonSerializable<DatabaseAccountKeysMetadata> {
    private AccountKeyMetadata primaryMasterKey;
    private AccountKeyMetadata secondaryMasterKey;
    private AccountKeyMetadata primaryReadonlyMasterKey;
    private AccountKeyMetadata secondaryReadonlyMasterKey;

    public AccountKeyMetadata primaryMasterKey() {
        return this.primaryMasterKey;
    }

    public AccountKeyMetadata secondaryMasterKey() {
        return this.secondaryMasterKey;
    }

    public AccountKeyMetadata primaryReadonlyMasterKey() {
        return this.primaryReadonlyMasterKey;
    }

    public AccountKeyMetadata secondaryReadonlyMasterKey() {
        return this.secondaryReadonlyMasterKey;
    }

    public void validate() {
        if (this.primaryMasterKey() != null) {
            this.primaryMasterKey().validate();
        }
        if (this.secondaryMasterKey() != null) {
            this.secondaryMasterKey().validate();
        }
        if (this.primaryReadonlyMasterKey() != null) {
            this.primaryReadonlyMasterKey().validate();
        }
        if (this.secondaryReadonlyMasterKey() != null) {
            this.secondaryReadonlyMasterKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountKeysMetadata fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountKeysMetadata)jsonReader.readObject(reader -> {
            DatabaseAccountKeysMetadata deserializedDatabaseAccountKeysMetadata = new DatabaseAccountKeysMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.primaryMasterKey = AccountKeyMetadata.fromJson(reader);
                    continue;
                }
                if ("secondaryMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.secondaryMasterKey = AccountKeyMetadata.fromJson(reader);
                    continue;
                }
                if ("primaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.primaryReadonlyMasterKey = AccountKeyMetadata.fromJson(reader);
                    continue;
                }
                if ("secondaryReadonlyMasterKey".equals(fieldName)) {
                    deserializedDatabaseAccountKeysMetadata.secondaryReadonlyMasterKey = AccountKeyMetadata.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountKeysMetadata;
        });
    }
}

