/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.AnalyticalStorageConfiguration;
import com.azure.resourcemanager.cosmos.models.ApiProperties;
import com.azure.resourcemanager.cosmos.models.BackupPolicy;
import com.azure.resourcemanager.cosmos.models.Capability;
import com.azure.resourcemanager.cosmos.models.Capacity;
import com.azure.resourcemanager.cosmos.models.ConnectorOffer;
import com.azure.resourcemanager.cosmos.models.ConsistencyPolicy;
import com.azure.resourcemanager.cosmos.models.CorsPolicy;
import com.azure.resourcemanager.cosmos.models.DatabaseAccountKeysMetadata;
import com.azure.resourcemanager.cosmos.models.IpAddressOrRange;
import com.azure.resourcemanager.cosmos.models.Location;
import com.azure.resourcemanager.cosmos.models.MinimalTlsVersion;
import com.azure.resourcemanager.cosmos.models.NetworkAclBypass;
import com.azure.resourcemanager.cosmos.models.PublicNetworkAccess;
import com.azure.resourcemanager.cosmos.models.VirtualNetworkRule;
import java.io.IOException;
import java.util.List;

public final class DatabaseAccountUpdateProperties
implements JsonSerializable<DatabaseAccountUpdateProperties> {
    private ConsistencyPolicy consistencyPolicy;
    private List<Location> locations;
    private List<IpAddressOrRange> ipRules;
    private Boolean isVirtualNetworkFilterEnabled;
    private Boolean enableAutomaticFailover;
    private List<Capability> capabilities;
    private List<VirtualNetworkRule> virtualNetworkRules;
    private Boolean enableMultipleWriteLocations;
    private Boolean enableCassandraConnector;
    private ConnectorOffer connectorOffer;
    private Boolean disableKeyBasedMetadataWriteAccess;
    private String keyVaultKeyUri;
    private String defaultIdentity;
    private PublicNetworkAccess publicNetworkAccess;
    private Boolean enableFreeTier;
    private ApiProperties apiProperties;
    private Boolean enableAnalyticalStorage;
    private AnalyticalStorageConfiguration analyticalStorageConfiguration;
    private BackupPolicy backupPolicy;
    private List<CorsPolicy> cors;
    private NetworkAclBypass networkAclBypass;
    private List<String> networkAclBypassResourceIds;
    private Boolean disableLocalAuth;
    private Capacity capacity;
    private DatabaseAccountKeysMetadata keysMetadata;
    private Boolean enablePartitionMerge;
    private MinimalTlsVersion minimalTlsVersion;
    private Boolean enableBurstCapacity;
    private String customerManagedKeyStatus;

    public ConsistencyPolicy consistencyPolicy() {
        return this.consistencyPolicy;
    }

    public DatabaseAccountUpdateProperties withConsistencyPolicy(ConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
        return this;
    }

    public List<Location> locations() {
        return this.locations;
    }

    public DatabaseAccountUpdateProperties withLocations(List<Location> locations) {
        this.locations = locations;
        return this;
    }

    public List<IpAddressOrRange> ipRules() {
        return this.ipRules;
    }

    public DatabaseAccountUpdateProperties withIpRules(List<IpAddressOrRange> ipRules) {
        this.ipRules = ipRules;
        return this;
    }

    public Boolean isVirtualNetworkFilterEnabled() {
        return this.isVirtualNetworkFilterEnabled;
    }

    public DatabaseAccountUpdateProperties withIsVirtualNetworkFilterEnabled(Boolean isVirtualNetworkFilterEnabled) {
        this.isVirtualNetworkFilterEnabled = isVirtualNetworkFilterEnabled;
        return this;
    }

    public Boolean enableAutomaticFailover() {
        return this.enableAutomaticFailover;
    }

    public DatabaseAccountUpdateProperties withEnableAutomaticFailover(Boolean enableAutomaticFailover) {
        this.enableAutomaticFailover = enableAutomaticFailover;
        return this;
    }

    public List<Capability> capabilities() {
        return this.capabilities;
    }

    public DatabaseAccountUpdateProperties withCapabilities(List<Capability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public List<VirtualNetworkRule> virtualNetworkRules() {
        return this.virtualNetworkRules;
    }

    public DatabaseAccountUpdateProperties withVirtualNetworkRules(List<VirtualNetworkRule> virtualNetworkRules) {
        this.virtualNetworkRules = virtualNetworkRules;
        return this;
    }

    public Boolean enableMultipleWriteLocations() {
        return this.enableMultipleWriteLocations;
    }

    public DatabaseAccountUpdateProperties withEnableMultipleWriteLocations(Boolean enableMultipleWriteLocations) {
        this.enableMultipleWriteLocations = enableMultipleWriteLocations;
        return this;
    }

    public Boolean enableCassandraConnector() {
        return this.enableCassandraConnector;
    }

    public DatabaseAccountUpdateProperties withEnableCassandraConnector(Boolean enableCassandraConnector) {
        this.enableCassandraConnector = enableCassandraConnector;
        return this;
    }

    public ConnectorOffer connectorOffer() {
        return this.connectorOffer;
    }

    public DatabaseAccountUpdateProperties withConnectorOffer(ConnectorOffer connectorOffer) {
        this.connectorOffer = connectorOffer;
        return this;
    }

    public Boolean disableKeyBasedMetadataWriteAccess() {
        return this.disableKeyBasedMetadataWriteAccess;
    }

    public DatabaseAccountUpdateProperties withDisableKeyBasedMetadataWriteAccess(Boolean disableKeyBasedMetadataWriteAccess) {
        this.disableKeyBasedMetadataWriteAccess = disableKeyBasedMetadataWriteAccess;
        return this;
    }

    public String keyVaultKeyUri() {
        return this.keyVaultKeyUri;
    }

    public DatabaseAccountUpdateProperties withKeyVaultKeyUri(String keyVaultKeyUri) {
        this.keyVaultKeyUri = keyVaultKeyUri;
        return this;
    }

    public String defaultIdentity() {
        return this.defaultIdentity;
    }

    public DatabaseAccountUpdateProperties withDefaultIdentity(String defaultIdentity) {
        this.defaultIdentity = defaultIdentity;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DatabaseAccountUpdateProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public Boolean enableFreeTier() {
        return this.enableFreeTier;
    }

    public DatabaseAccountUpdateProperties withEnableFreeTier(Boolean enableFreeTier) {
        this.enableFreeTier = enableFreeTier;
        return this;
    }

    public ApiProperties apiProperties() {
        return this.apiProperties;
    }

    public DatabaseAccountUpdateProperties withApiProperties(ApiProperties apiProperties) {
        this.apiProperties = apiProperties;
        return this;
    }

    public Boolean enableAnalyticalStorage() {
        return this.enableAnalyticalStorage;
    }

    public DatabaseAccountUpdateProperties withEnableAnalyticalStorage(Boolean enableAnalyticalStorage) {
        this.enableAnalyticalStorage = enableAnalyticalStorage;
        return this;
    }

    public AnalyticalStorageConfiguration analyticalStorageConfiguration() {
        return this.analyticalStorageConfiguration;
    }

    public DatabaseAccountUpdateProperties withAnalyticalStorageConfiguration(AnalyticalStorageConfiguration analyticalStorageConfiguration) {
        this.analyticalStorageConfiguration = analyticalStorageConfiguration;
        return this;
    }

    public BackupPolicy backupPolicy() {
        return this.backupPolicy;
    }

    public DatabaseAccountUpdateProperties withBackupPolicy(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
        return this;
    }

    public List<CorsPolicy> cors() {
        return this.cors;
    }

    public DatabaseAccountUpdateProperties withCors(List<CorsPolicy> cors) {
        this.cors = cors;
        return this;
    }

    public NetworkAclBypass networkAclBypass() {
        return this.networkAclBypass;
    }

    public DatabaseAccountUpdateProperties withNetworkAclBypass(NetworkAclBypass networkAclBypass) {
        this.networkAclBypass = networkAclBypass;
        return this;
    }

    public List<String> networkAclBypassResourceIds() {
        return this.networkAclBypassResourceIds;
    }

    public DatabaseAccountUpdateProperties withNetworkAclBypassResourceIds(List<String> networkAclBypassResourceIds) {
        this.networkAclBypassResourceIds = networkAclBypassResourceIds;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public DatabaseAccountUpdateProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public DatabaseAccountUpdateProperties withCapacity(Capacity capacity) {
        this.capacity = capacity;
        return this;
    }

    public DatabaseAccountKeysMetadata keysMetadata() {
        return this.keysMetadata;
    }

    public Boolean enablePartitionMerge() {
        return this.enablePartitionMerge;
    }

    public DatabaseAccountUpdateProperties withEnablePartitionMerge(Boolean enablePartitionMerge) {
        this.enablePartitionMerge = enablePartitionMerge;
        return this;
    }

    public MinimalTlsVersion minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public DatabaseAccountUpdateProperties withMinimalTlsVersion(MinimalTlsVersion minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public Boolean enableBurstCapacity() {
        return this.enableBurstCapacity;
    }

    public DatabaseAccountUpdateProperties withEnableBurstCapacity(Boolean enableBurstCapacity) {
        this.enableBurstCapacity = enableBurstCapacity;
        return this;
    }

    public String customerManagedKeyStatus() {
        return this.customerManagedKeyStatus;
    }

    public DatabaseAccountUpdateProperties withCustomerManagedKeyStatus(String customerManagedKeyStatus) {
        this.customerManagedKeyStatus = customerManagedKeyStatus;
        return this;
    }

    public void validate() {
        if (this.consistencyPolicy() != null) {
            this.consistencyPolicy().validate();
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.ipRules() != null) {
            this.ipRules().forEach(e -> e.validate());
        }
        if (this.capabilities() != null) {
            this.capabilities().forEach(e -> e.validate());
        }
        if (this.virtualNetworkRules() != null) {
            this.virtualNetworkRules().forEach(e -> e.validate());
        }
        if (this.apiProperties() != null) {
            this.apiProperties().validate();
        }
        if (this.analyticalStorageConfiguration() != null) {
            this.analyticalStorageConfiguration().validate();
        }
        if (this.backupPolicy() != null) {
            this.backupPolicy().validate();
        }
        if (this.cors() != null) {
            this.cors().forEach(e -> e.validate());
        }
        if (this.capacity() != null) {
            this.capacity().validate();
        }
        if (this.keysMetadata() != null) {
            this.keysMetadata().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("consistencyPolicy", (JsonSerializable)this.consistencyPolicy);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("ipRules", this.ipRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isVirtualNetworkFilterEnabled", this.isVirtualNetworkFilterEnabled);
        jsonWriter.writeBooleanField("enableAutomaticFailover", this.enableAutomaticFailover);
        jsonWriter.writeArrayField("capabilities", this.capabilities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("virtualNetworkRules", this.virtualNetworkRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("enableMultipleWriteLocations", this.enableMultipleWriteLocations);
        jsonWriter.writeBooleanField("enableCassandraConnector", this.enableCassandraConnector);
        jsonWriter.writeStringField("connectorOffer", this.connectorOffer == null ? null : this.connectorOffer.toString());
        jsonWriter.writeBooleanField("disableKeyBasedMetadataWriteAccess", this.disableKeyBasedMetadataWriteAccess);
        jsonWriter.writeStringField("keyVaultKeyUri", this.keyVaultKeyUri);
        jsonWriter.writeStringField("defaultIdentity", this.defaultIdentity);
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeBooleanField("enableFreeTier", this.enableFreeTier);
        jsonWriter.writeJsonField("apiProperties", (JsonSerializable)this.apiProperties);
        jsonWriter.writeBooleanField("enableAnalyticalStorage", this.enableAnalyticalStorage);
        jsonWriter.writeJsonField("analyticalStorageConfiguration", (JsonSerializable)this.analyticalStorageConfiguration);
        jsonWriter.writeJsonField("backupPolicy", (JsonSerializable)this.backupPolicy);
        jsonWriter.writeArrayField("cors", this.cors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkAclBypass", this.networkAclBypass == null ? null : this.networkAclBypass.toString());
        jsonWriter.writeArrayField("networkAclBypassResourceIds", this.networkAclBypassResourceIds, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("disableLocalAuth", this.disableLocalAuth);
        jsonWriter.writeJsonField("capacity", (JsonSerializable)this.capacity);
        jsonWriter.writeBooleanField("enablePartitionMerge", this.enablePartitionMerge);
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeBooleanField("enableBurstCapacity", this.enableBurstCapacity);
        jsonWriter.writeStringField("customerManagedKeyStatus", this.customerManagedKeyStatus);
        return jsonWriter.writeEndObject();
    }

    public static DatabaseAccountUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DatabaseAccountUpdateProperties)jsonReader.readObject(reader -> {
            DatabaseAccountUpdateProperties deserializedDatabaseAccountUpdateProperties = new DatabaseAccountUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("consistencyPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.consistencyPolicy = ConsistencyPolicy.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedDatabaseAccountUpdateProperties.locations = locations = reader.readArray(reader1 -> Location.fromJson(reader1));
                    continue;
                }
                if ("ipRules".equals(fieldName)) {
                    List ipRules;
                    deserializedDatabaseAccountUpdateProperties.ipRules = ipRules = reader.readArray(reader1 -> IpAddressOrRange.fromJson(reader1));
                    continue;
                }
                if ("isVirtualNetworkFilterEnabled".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.isVirtualNetworkFilterEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableAutomaticFailover".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableAutomaticFailover = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    List capabilities;
                    deserializedDatabaseAccountUpdateProperties.capabilities = capabilities = reader.readArray(reader1 -> Capability.fromJson(reader1));
                    continue;
                }
                if ("virtualNetworkRules".equals(fieldName)) {
                    List virtualNetworkRules;
                    deserializedDatabaseAccountUpdateProperties.virtualNetworkRules = virtualNetworkRules = reader.readArray(reader1 -> VirtualNetworkRule.fromJson(reader1));
                    continue;
                }
                if ("enableMultipleWriteLocations".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableMultipleWriteLocations = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("enableCassandraConnector".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableCassandraConnector = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("connectorOffer".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.connectorOffer = ConnectorOffer.fromString(reader.getString());
                    continue;
                }
                if ("disableKeyBasedMetadataWriteAccess".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.disableKeyBasedMetadataWriteAccess = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("keyVaultKeyUri".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.keyVaultKeyUri = reader.getString();
                    continue;
                }
                if ("defaultIdentity".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.defaultIdentity = reader.getString();
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.publicNetworkAccess = PublicNetworkAccess.fromString(reader.getString());
                    continue;
                }
                if ("enableFreeTier".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableFreeTier = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("apiProperties".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.apiProperties = ApiProperties.fromJson(reader);
                    continue;
                }
                if ("enableAnalyticalStorage".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableAnalyticalStorage = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("analyticalStorageConfiguration".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.analyticalStorageConfiguration = AnalyticalStorageConfiguration.fromJson(reader);
                    continue;
                }
                if ("backupPolicy".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.backupPolicy = BackupPolicy.fromJson(reader);
                    continue;
                }
                if ("cors".equals(fieldName)) {
                    List cors;
                    deserializedDatabaseAccountUpdateProperties.cors = cors = reader.readArray(reader1 -> CorsPolicy.fromJson(reader1));
                    continue;
                }
                if ("networkAclBypass".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.networkAclBypass = NetworkAclBypass.fromString(reader.getString());
                    continue;
                }
                if ("networkAclBypassResourceIds".equals(fieldName)) {
                    List networkAclBypassResourceIds;
                    deserializedDatabaseAccountUpdateProperties.networkAclBypassResourceIds = networkAclBypassResourceIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("disableLocalAuth".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.disableLocalAuth = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("capacity".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.capacity = Capacity.fromJson(reader);
                    continue;
                }
                if ("keysMetadata".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.keysMetadata = DatabaseAccountKeysMetadata.fromJson(reader);
                    continue;
                }
                if ("enablePartitionMerge".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enablePartitionMerge = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.minimalTlsVersion = MinimalTlsVersion.fromString(reader.getString());
                    continue;
                }
                if ("enableBurstCapacity".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.enableBurstCapacity = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("customerManagedKeyStatus".equals(fieldName)) {
                    deserializedDatabaseAccountUpdateProperties.customerManagedKeyStatus = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDatabaseAccountUpdateProperties;
        });
    }
}

