/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cosmos.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cosmos.models.ConflictResolutionPolicy;
import com.azure.resourcemanager.cosmos.models.ContainerPartitionKey;
import com.azure.resourcemanager.cosmos.models.CreateMode;
import com.azure.resourcemanager.cosmos.models.IndexingPolicy;
import com.azure.resourcemanager.cosmos.models.ResourceRestoreParameters;
import com.azure.resourcemanager.cosmos.models.UniqueKeyPolicy;
import java.io.IOException;

public class GremlinGraphResource
implements JsonSerializable<GremlinGraphResource> {
    private String id;
    private IndexingPolicy indexingPolicy;
    private ContainerPartitionKey partitionKey;
    private Integer defaultTtl;
    private UniqueKeyPolicy uniqueKeyPolicy;
    private ConflictResolutionPolicy conflictResolutionPolicy;
    private Long analyticalStorageTtl;
    private ResourceRestoreParameters restoreParameters;
    private CreateMode createMode;
    private static final ClientLogger LOGGER = new ClientLogger(GremlinGraphResource.class);

    public String id() {
        return this.id;
    }

    public GremlinGraphResource withId(String id) {
        this.id = id;
        return this;
    }

    public IndexingPolicy indexingPolicy() {
        return this.indexingPolicy;
    }

    public GremlinGraphResource withIndexingPolicy(IndexingPolicy indexingPolicy) {
        this.indexingPolicy = indexingPolicy;
        return this;
    }

    public ContainerPartitionKey partitionKey() {
        return this.partitionKey;
    }

    public GremlinGraphResource withPartitionKey(ContainerPartitionKey partitionKey) {
        this.partitionKey = partitionKey;
        return this;
    }

    public Integer defaultTtl() {
        return this.defaultTtl;
    }

    public GremlinGraphResource withDefaultTtl(Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    public UniqueKeyPolicy uniqueKeyPolicy() {
        return this.uniqueKeyPolicy;
    }

    public GremlinGraphResource withUniqueKeyPolicy(UniqueKeyPolicy uniqueKeyPolicy) {
        this.uniqueKeyPolicy = uniqueKeyPolicy;
        return this;
    }

    public ConflictResolutionPolicy conflictResolutionPolicy() {
        return this.conflictResolutionPolicy;
    }

    public GremlinGraphResource withConflictResolutionPolicy(ConflictResolutionPolicy conflictResolutionPolicy) {
        this.conflictResolutionPolicy = conflictResolutionPolicy;
        return this;
    }

    public Long analyticalStorageTtl() {
        return this.analyticalStorageTtl;
    }

    public GremlinGraphResource withAnalyticalStorageTtl(Long analyticalStorageTtl) {
        this.analyticalStorageTtl = analyticalStorageTtl;
        return this;
    }

    public ResourceRestoreParameters restoreParameters() {
        return this.restoreParameters;
    }

    public GremlinGraphResource withRestoreParameters(ResourceRestoreParameters restoreParameters) {
        this.restoreParameters = restoreParameters;
        return this;
    }

    public CreateMode createMode() {
        return this.createMode;
    }

    public GremlinGraphResource withCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public void validate() {
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model GremlinGraphResource"));
        }
        if (this.indexingPolicy() != null) {
            this.indexingPolicy().validate();
        }
        if (this.partitionKey() != null) {
            this.partitionKey().validate();
        }
        if (this.uniqueKeyPolicy() != null) {
            this.uniqueKeyPolicy().validate();
        }
        if (this.conflictResolutionPolicy() != null) {
            this.conflictResolutionPolicy().validate();
        }
        if (this.restoreParameters() != null) {
            this.restoreParameters().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("indexingPolicy", (JsonSerializable)this.indexingPolicy);
        jsonWriter.writeJsonField("partitionKey", (JsonSerializable)this.partitionKey);
        jsonWriter.writeNumberField("defaultTtl", (Number)this.defaultTtl);
        jsonWriter.writeJsonField("uniqueKeyPolicy", (JsonSerializable)this.uniqueKeyPolicy);
        jsonWriter.writeJsonField("conflictResolutionPolicy", (JsonSerializable)this.conflictResolutionPolicy);
        jsonWriter.writeNumberField("analyticalStorageTtl", (Number)this.analyticalStorageTtl);
        jsonWriter.writeJsonField("restoreParameters", (JsonSerializable)this.restoreParameters);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static GremlinGraphResource fromJson(JsonReader jsonReader) throws IOException {
        return (GremlinGraphResource)jsonReader.readObject(reader -> {
            GremlinGraphResource deserializedGremlinGraphResource = new GremlinGraphResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGremlinGraphResource.id = reader.getString();
                    continue;
                }
                if ("indexingPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.indexingPolicy = IndexingPolicy.fromJson(reader);
                    continue;
                }
                if ("partitionKey".equals(fieldName)) {
                    deserializedGremlinGraphResource.partitionKey = ContainerPartitionKey.fromJson(reader);
                    continue;
                }
                if ("defaultTtl".equals(fieldName)) {
                    deserializedGremlinGraphResource.defaultTtl = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("uniqueKeyPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.uniqueKeyPolicy = UniqueKeyPolicy.fromJson(reader);
                    continue;
                }
                if ("conflictResolutionPolicy".equals(fieldName)) {
                    deserializedGremlinGraphResource.conflictResolutionPolicy = ConflictResolutionPolicy.fromJson(reader);
                    continue;
                }
                if ("analyticalStorageTtl".equals(fieldName)) {
                    deserializedGremlinGraphResource.analyticalStorageTtl = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("restoreParameters".equals(fieldName)) {
                    deserializedGremlinGraphResource.restoreParameters = ResourceRestoreParameters.fromJson(reader);
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedGremlinGraphResource.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGremlinGraphResource;
        });
    }
}

