/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.eventhubs.fluent.ClustersClient;
import com.azure.resourcemanager.eventhubs.fluent.ConfigurationsClient;
import com.azure.resourcemanager.eventhubs.fluent.ConsumerGroupsClient;
import com.azure.resourcemanager.eventhubs.fluent.DisasterRecoveryConfigsClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubManagementClient;
import com.azure.resourcemanager.eventhubs.fluent.EventHubsClient;
import com.azure.resourcemanager.eventhubs.fluent.NamespacesClient;
import com.azure.resourcemanager.eventhubs.fluent.OperationsClient;
import com.azure.resourcemanager.eventhubs.fluent.PrivateEndpointConnectionsClient;
import com.azure.resourcemanager.eventhubs.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.eventhubs.fluent.SchemaRegistriesClient;
import com.azure.resourcemanager.eventhubs.implementation.ClustersClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.ConfigurationsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.ConsumerGroupsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.DisasterRecoveryConfigsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.EventHubManagementClientBuilder;
import com.azure.resourcemanager.eventhubs.implementation.EventHubsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.NamespacesClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.OperationsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.PrivateEndpointConnectionsClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.PrivateLinkResourcesClientImpl;
import com.azure.resourcemanager.eventhubs.implementation.SchemaRegistriesClientImpl;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

@ServiceClient(builder=EventHubManagementClientBuilder.class)
public final class EventHubManagementClientImpl
extends AzureServiceClient
implements EventHubManagementClient {
    private final ClientLogger logger = new ClientLogger(EventHubManagementClientImpl.class);
    private final String subscriptionId;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final Duration defaultPollInterval;
    private final ClustersClient clusters;
    private final ConfigurationsClient configurations;
    private final NamespacesClient namespaces;
    private final PrivateEndpointConnectionsClient privateEndpointConnections;
    private final PrivateLinkResourcesClient privateLinkResources;
    private final OperationsClient operations;
    private final EventHubsClient eventHubs;
    private final DisasterRecoveryConfigsClient disasterRecoveryConfigs;
    private final ConsumerGroupsClient consumerGroups;
    private final SchemaRegistriesClient schemaRegistries;

    @Override
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    @Override
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    @Override
    public ClustersClient getClusters() {
        return this.clusters;
    }

    @Override
    public ConfigurationsClient getConfigurations() {
        return this.configurations;
    }

    @Override
    public NamespacesClient getNamespaces() {
        return this.namespaces;
    }

    @Override
    public PrivateEndpointConnectionsClient getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    @Override
    public PrivateLinkResourcesClient getPrivateLinkResources() {
        return this.privateLinkResources;
    }

    @Override
    public OperationsClient getOperations() {
        return this.operations;
    }

    @Override
    public EventHubsClient getEventHubs() {
        return this.eventHubs;
    }

    @Override
    public DisasterRecoveryConfigsClient getDisasterRecoveryConfigs() {
        return this.disasterRecoveryConfigs;
    }

    @Override
    public ConsumerGroupsClient getConsumerGroups() {
        return this.consumerGroups;
    }

    @Override
    public SchemaRegistriesClient getSchemaRegistries() {
        return this.schemaRegistries;
    }

    EventHubManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2021-11-01";
        this.clusters = new ClustersClientImpl(this);
        this.configurations = new ConfigurationsClientImpl(this);
        this.namespaces = new NamespacesClientImpl(this);
        this.privateEndpointConnections = new PrivateEndpointConnectionsClientImpl(this);
        this.privateLinkResources = new PrivateLinkResourcesClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.eventHubs = new EventHubsClientImpl(this);
        this.disasterRecoveryConfigs = new DisasterRecoveryConfigsClientImpl(this);
        this.consumerGroups = new ConsumerGroupsClientImpl(this);
        this.schemaRegistries = new SchemaRegistriesClientImpl(this);
    }
}

