/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicy;
import com.azure.resourcemanager.eventhubs.models.ApplicationGroupPolicyType;
import com.azure.resourcemanager.eventhubs.models.MetricId;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeId;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=ThrottlingPolicy.class, visible=true)
@JsonTypeName(value="ThrottlingPolicy")
public final class ThrottlingPolicy
extends ApplicationGroupPolicy {
    @JsonTypeId
    @JsonProperty(value="type", required=true)
    private ApplicationGroupPolicyType type = ApplicationGroupPolicyType.THROTTLING_POLICY;
    @JsonProperty(value="rateLimitThreshold", required=true)
    private long rateLimitThreshold;
    @JsonProperty(value="metricId", required=true)
    private MetricId metricId;
    private static final ClientLogger LOGGER = new ClientLogger(ThrottlingPolicy.class);

    @Override
    public ApplicationGroupPolicyType type() {
        return this.type;
    }

    public long rateLimitThreshold() {
        return this.rateLimitThreshold;
    }

    public ThrottlingPolicy withRateLimitThreshold(long rateLimitThreshold) {
        this.rateLimitThreshold = rateLimitThreshold;
        return this;
    }

    public MetricId metricId() {
        return this.metricId;
    }

    public ThrottlingPolicy withMetricId(MetricId metricId) {
        this.metricId = metricId;
        return this;
    }

    @Override
    public ThrottlingPolicy withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.metricId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property metricId in model ThrottlingPolicy"));
        }
    }
}

