/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.SchemaCompatibility;
import com.azure.resourcemanager.eventhubs.models.SchemaType;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.UUID;

public final class SchemaGroupProperties
implements JsonSerializable<SchemaGroupProperties> {
    private OffsetDateTime updatedAtUtc;
    private OffsetDateTime createdAtUtc;
    private UUID etag;
    private Map<String, String> groupProperties;
    private SchemaCompatibility schemaCompatibility;
    private SchemaType schemaType;

    public OffsetDateTime updatedAtUtc() {
        return this.updatedAtUtc;
    }

    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    public UUID etag() {
        return this.etag;
    }

    public Map<String, String> groupProperties() {
        return this.groupProperties;
    }

    public SchemaGroupProperties withGroupProperties(Map<String, String> groupProperties) {
        this.groupProperties = groupProperties;
        return this;
    }

    public SchemaCompatibility schemaCompatibility() {
        return this.schemaCompatibility;
    }

    public SchemaGroupProperties withSchemaCompatibility(SchemaCompatibility schemaCompatibility) {
        this.schemaCompatibility = schemaCompatibility;
        return this;
    }

    public SchemaType schemaType() {
        return this.schemaType;
    }

    public SchemaGroupProperties withSchemaType(SchemaType schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("groupProperties", this.groupProperties, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("schemaCompatibility", this.schemaCompatibility == null ? null : this.schemaCompatibility.toString());
        jsonWriter.writeStringField("schemaType", this.schemaType == null ? null : this.schemaType.toString());
        return jsonWriter.writeEndObject();
    }

    public static SchemaGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SchemaGroupProperties)jsonReader.readObject(reader -> {
            SchemaGroupProperties deserializedSchemaGroupProperties = new SchemaGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("updatedAtUtc".equals(fieldName)) {
                    deserializedSchemaGroupProperties.updatedAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdAtUtc".equals(fieldName)) {
                    deserializedSchemaGroupProperties.createdAtUtc = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("eTag".equals(fieldName)) {
                    deserializedSchemaGroupProperties.etag = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("groupProperties".equals(fieldName)) {
                    Map groupProperties;
                    deserializedSchemaGroupProperties.groupProperties = groupProperties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("schemaCompatibility".equals(fieldName)) {
                    deserializedSchemaGroupProperties.schemaCompatibility = SchemaCompatibility.fromString(reader.getString());
                    continue;
                }
                if ("schemaType".equals(fieldName)) {
                    deserializedSchemaGroupProperties.schemaType = SchemaType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSchemaGroupProperties;
        });
    }
}

