/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.NspAccessRuleProperties;
import java.io.IOException;

public final class NspAccessRule
implements JsonSerializable<NspAccessRule> {
    private String id;
    private String name;
    private String type;
    private NspAccessRuleProperties properties;

    public String id() {
        return this.id;
    }

    public NspAccessRule withId(String id) {
        this.id = id;
        return this;
    }

    public String name() {
        return this.name;
    }

    public NspAccessRule withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public NspAccessRule withType(String type) {
        this.type = type;
        return this;
    }

    public NspAccessRuleProperties properties() {
        return this.properties;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static NspAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return (NspAccessRule)jsonReader.readObject(reader -> {
            NspAccessRule deserializedNspAccessRule = new NspAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspAccessRule.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspAccessRule.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspAccessRule.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspAccessRule.properties = NspAccessRuleProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAccessRule;
        });
    }
}

