/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.CleanupPolicyRetentionDescription;
import java.io.IOException;

public final class RetentionDescription
implements JsonSerializable<RetentionDescription> {
    private CleanupPolicyRetentionDescription cleanupPolicy;
    private Long retentionTimeInHours;
    private Integer tombstoneRetentionTimeInHours;

    public CleanupPolicyRetentionDescription cleanupPolicy() {
        return this.cleanupPolicy;
    }

    public RetentionDescription withCleanupPolicy(CleanupPolicyRetentionDescription cleanupPolicy) {
        this.cleanupPolicy = cleanupPolicy;
        return this;
    }

    public Long retentionTimeInHours() {
        return this.retentionTimeInHours;
    }

    public RetentionDescription withRetentionTimeInHours(Long retentionTimeInHours) {
        this.retentionTimeInHours = retentionTimeInHours;
        return this;
    }

    public Integer tombstoneRetentionTimeInHours() {
        return this.tombstoneRetentionTimeInHours;
    }

    public RetentionDescription withTombstoneRetentionTimeInHours(Integer tombstoneRetentionTimeInHours) {
        this.tombstoneRetentionTimeInHours = tombstoneRetentionTimeInHours;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("cleanupPolicy", this.cleanupPolicy == null ? null : this.cleanupPolicy.toString());
        jsonWriter.writeNumberField("retentionTimeInHours", (Number)this.retentionTimeInHours);
        jsonWriter.writeNumberField("tombstoneRetentionTimeInHours", (Number)this.tombstoneRetentionTimeInHours);
        return jsonWriter.writeEndObject();
    }

    public static RetentionDescription fromJson(JsonReader jsonReader) throws IOException {
        return (RetentionDescription)jsonReader.readObject(reader -> {
            RetentionDescription deserializedRetentionDescription = new RetentionDescription();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("cleanupPolicy".equals(fieldName)) {
                    deserializedRetentionDescription.cleanupPolicy = CleanupPolicyRetentionDescription.fromString(reader.getString());
                    continue;
                }
                if ("retentionTimeInHours".equals(fieldName)) {
                    deserializedRetentionDescription.retentionTimeInHours = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("tombstoneRetentionTimeInHours".equals(fieldName)) {
                    deserializedRetentionDescription.tombstoneRetentionTimeInHours = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRetentionDescription;
        });
    }
}

