/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.eventhubs.models.NspAccessRule;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityPerimeterConfigurationPropertiesProfile
implements JsonSerializable<NetworkSecurityPerimeterConfigurationPropertiesProfile> {
    private String name;
    private String accessRulesVersion;
    private List<NspAccessRule> accessRules;

    public String name() {
        return this.name;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile withName(String name) {
        this.name = name;
        return this;
    }

    public String accessRulesVersion() {
        return this.accessRulesVersion;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile withAccessRulesVersion(String accessRulesVersion) {
        this.accessRulesVersion = accessRulesVersion;
        return this;
    }

    public List<NspAccessRule> accessRules() {
        return this.accessRules;
    }

    public NetworkSecurityPerimeterConfigurationPropertiesProfile withAccessRules(List<NspAccessRule> accessRules) {
        this.accessRules = accessRules;
        return this;
    }

    public void validate() {
        if (this.accessRules() != null) {
            this.accessRules().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("accessRulesVersion", this.accessRulesVersion);
        jsonWriter.writeArrayField("accessRules", this.accessRules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityPerimeterConfigurationPropertiesProfile fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityPerimeterConfigurationPropertiesProfile)jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterConfigurationPropertiesProfile deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile = new NetworkSecurityPerimeterConfigurationPropertiesProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.name = reader.getString();
                    continue;
                }
                if ("accessRulesVersion".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.accessRulesVersion = reader.getString();
                    continue;
                }
                if ("accessRules".equals(fieldName)) {
                    List accessRules;
                    deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile.accessRules = accessRules = reader.readArray(reader1 -> NspAccessRule.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityPerimeterConfigurationPropertiesProfile;
        });
    }
}

