/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmKeyProperties;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyCurveName;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyOperation;
import com.azure.resourcemanager.keyvault.models.JsonWebKeyType;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyAttributes;
import com.azure.resourcemanager.keyvault.models.ManagedHsmKeyReleasePolicy;
import com.azure.resourcemanager.keyvault.models.ManagedHsmRotationPolicy;
import com.azure.resourcemanager.keyvault.models.ProxyResourceWithoutSystemData;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ManagedHsmKeyInner
extends ProxyResourceWithoutSystemData {
    private ManagedHsmKeyProperties innerProperties = new ManagedHsmKeyProperties();
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedHsmKeyInner.class);

    private ManagedHsmKeyProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public ManagedHsmKeyInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ManagedHsmKeyAttributes attributes() {
        return this.innerProperties() == null ? null : this.innerProperties().attributes();
    }

    public ManagedHsmKeyInner withAttributes(ManagedHsmKeyAttributes attributes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withAttributes(attributes);
        return this;
    }

    public JsonWebKeyType kty() {
        return this.innerProperties() == null ? null : this.innerProperties().kty();
    }

    public ManagedHsmKeyInner withKty(JsonWebKeyType kty) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withKty(kty);
        return this;
    }

    public List<JsonWebKeyOperation> keyOps() {
        return this.innerProperties() == null ? null : this.innerProperties().keyOps();
    }

    public ManagedHsmKeyInner withKeyOps(List<JsonWebKeyOperation> keyOps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withKeyOps(keyOps);
        return this;
    }

    public Integer keySize() {
        return this.innerProperties() == null ? null : this.innerProperties().keySize();
    }

    public ManagedHsmKeyInner withKeySize(Integer keySize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withKeySize(keySize);
        return this;
    }

    public JsonWebKeyCurveName curveName() {
        return this.innerProperties() == null ? null : this.innerProperties().curveName();
    }

    public ManagedHsmKeyInner withCurveName(JsonWebKeyCurveName curveName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withCurveName(curveName);
        return this;
    }

    public String keyUri() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUri();
    }

    public String keyUriWithVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().keyUriWithVersion();
    }

    public ManagedHsmRotationPolicy rotationPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationPolicy();
    }

    public ManagedHsmKeyInner withRotationPolicy(ManagedHsmRotationPolicy rotationPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withRotationPolicy(rotationPolicy);
        return this;
    }

    public ManagedHsmKeyReleasePolicy releasePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().releasePolicy();
    }

    public ManagedHsmKeyInner withReleasePolicy(ManagedHsmKeyReleasePolicy releasePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ManagedHsmKeyProperties();
        }
        this.innerProperties().withReleasePolicy(releasePolicy);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ManagedHsmKeyInner"));
        }
        this.innerProperties().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedHsmKeyInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedHsmKeyInner)((Object)jsonReader.readObject(reader -> {
            ManagedHsmKeyInner deserializedManagedHsmKeyInner = new ManagedHsmKeyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedHsmKeyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedHsmKeyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedHsmKeyInner.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedHsmKeyInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedHsmKeyInner.innerProperties = ManagedHsmKeyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedHsmKeyInner;
        }));
    }
}

