/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.fluent.models.KeyProperties;
import java.io.IOException;
import java.util.Map;

public final class KeyCreateParameters
implements JsonSerializable<KeyCreateParameters> {
    private Map<String, String> tags;
    private KeyProperties properties;
    private static final ClientLogger LOGGER = new ClientLogger(KeyCreateParameters.class);

    public Map<String, String> tags() {
        return this.tags;
    }

    public KeyCreateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public KeyProperties properties() {
        return this.properties;
    }

    public KeyCreateParameters withProperties(KeyProperties properties) {
        this.properties = properties;
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model KeyCreateParameters"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static KeyCreateParameters fromJson(JsonReader jsonReader) throws IOException {
        return (KeyCreateParameters)jsonReader.readObject(reader -> {
            KeyCreateParameters deserializedKeyCreateParameters = new KeyCreateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedKeyCreateParameters.properties = KeyProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedKeyCreateParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyCreateParameters;
        });
    }
}

