/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.keyvault.models.Attributes;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;

public final class SecretAttributes
extends Attributes {
    private Long created;
    private Long updated;

    @Override
    public OffsetDateTime created() {
        if (this.created == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.created), ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime updated() {
        if (this.updated == null) {
            return null;
        }
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.updated), ZoneOffset.UTC);
    }

    @Override
    public SecretAttributes withEnabled(Boolean enabled) {
        super.withEnabled(enabled);
        return this;
    }

    @Override
    public SecretAttributes withNotBefore(OffsetDateTime notBefore) {
        super.withNotBefore(notBefore);
        return this;
    }

    @Override
    public SecretAttributes withExpires(OffsetDateTime expires) {
        super.withExpires(expires);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled());
        if (this.notBefore() != null) {
            jsonWriter.writeNumberField("nbf", (Number)this.notBefore().toEpochSecond());
        }
        if (this.expires() != null) {
            jsonWriter.writeNumberField("exp", (Number)this.expires().toEpochSecond());
        }
        return jsonWriter.writeEndObject();
    }

    public static SecretAttributes fromJson(JsonReader jsonReader) throws IOException {
        return (SecretAttributes)jsonReader.readObject(reader -> {
            SecretAttributes deserializedSecretAttributes = new SecretAttributes();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedSecretAttributes.withEnabled((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("nbf".equals(fieldName)) {
                    Long notBeforeHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (notBeforeHolder == null) continue;
                    deserializedSecretAttributes.withNotBefore(OffsetDateTime.ofInstant(Instant.ofEpochSecond(notBeforeHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("exp".equals(fieldName)) {
                    Long expiresHolder = (Long)reader.getNullable(JsonReader::getLong);
                    if (expiresHolder == null) continue;
                    deserializedSecretAttributes.withExpires(OffsetDateTime.ofInstant(Instant.ofEpochSecond(expiresHolder), ZoneOffset.UTC));
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSecretAttributes.created = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("updated".equals(fieldName)) {
                    deserializedSecretAttributes.updated = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecretAttributes;
        });
    }
}

