/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.management.http.policy.ArmChallengeAuthenticationPolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.fluent.KustoManagementClient;
import com.azure.resourcemanager.kusto.implementation.AttachedDatabaseConfigurationsImpl;
import com.azure.resourcemanager.kusto.implementation.ClusterPrincipalAssignmentsImpl;
import com.azure.resourcemanager.kusto.implementation.ClustersImpl;
import com.azure.resourcemanager.kusto.implementation.DataConnectionsImpl;
import com.azure.resourcemanager.kusto.implementation.DatabaseOperationsImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasePrincipalAssignmentsImpl;
import com.azure.resourcemanager.kusto.implementation.DatabasesImpl;
import com.azure.resourcemanager.kusto.implementation.KustoManagementClientBuilder;
import com.azure.resourcemanager.kusto.implementation.ManagedPrivateEndpointsImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsResultsImpl;
import com.azure.resourcemanager.kusto.implementation.OperationsResultsLocationsImpl;
import com.azure.resourcemanager.kusto.implementation.PrivateEndpointConnectionsImpl;
import com.azure.resourcemanager.kusto.implementation.PrivateLinkResourcesImpl;
import com.azure.resourcemanager.kusto.implementation.SandboxCustomImagesImpl;
import com.azure.resourcemanager.kusto.implementation.ScriptsImpl;
import com.azure.resourcemanager.kusto.implementation.SkusImpl;
import com.azure.resourcemanager.kusto.models.AttachedDatabaseConfigurations;
import com.azure.resourcemanager.kusto.models.ClusterPrincipalAssignments;
import com.azure.resourcemanager.kusto.models.Clusters;
import com.azure.resourcemanager.kusto.models.DataConnections;
import com.azure.resourcemanager.kusto.models.DatabaseOperations;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalAssignments;
import com.azure.resourcemanager.kusto.models.Databases;
import com.azure.resourcemanager.kusto.models.ManagedPrivateEndpoints;
import com.azure.resourcemanager.kusto.models.Operations;
import com.azure.resourcemanager.kusto.models.OperationsResults;
import com.azure.resourcemanager.kusto.models.OperationsResultsLocations;
import com.azure.resourcemanager.kusto.models.PrivateEndpointConnections;
import com.azure.resourcemanager.kusto.models.PrivateLinkResources;
import com.azure.resourcemanager.kusto.models.SandboxCustomImages;
import com.azure.resourcemanager.kusto.models.Scripts;
import com.azure.resourcemanager.kusto.models.Skus;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class KustoManager {
    private Clusters clusters;
    private ClusterPrincipalAssignments clusterPrincipalAssignments;
    private Skus skus;
    private Databases databases;
    private AttachedDatabaseConfigurations attachedDatabaseConfigurations;
    private ManagedPrivateEndpoints managedPrivateEndpoints;
    private DatabaseOperations databaseOperations;
    private DatabasePrincipalAssignments databasePrincipalAssignments;
    private Scripts scripts;
    private SandboxCustomImages sandboxCustomImages;
    private PrivateEndpointConnections privateEndpointConnections;
    private PrivateLinkResources privateLinkResources;
    private DataConnections dataConnections;
    private Operations operations;
    private OperationsResults operationsResults;
    private OperationsResultsLocations operationsResultsLocations;
    private final KustoManagementClient clientObject;

    private KustoManager(HttpPipeline httpPipeline, AzureProfile profile, Duration defaultPollInterval) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        this.clientObject = new KustoManagementClientBuilder().pipeline(httpPipeline).endpoint(profile.getEnvironment().getResourceManagerEndpoint()).subscriptionId(profile.getSubscriptionId()).defaultPollInterval(defaultPollInterval).buildClient();
    }

    public static KustoManager authenticate(TokenCredential credential, AzureProfile profile) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return KustoManager.configure().authenticate(credential, profile);
    }

    public static KustoManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        Objects.requireNonNull(httpPipeline, "'httpPipeline' cannot be null.");
        Objects.requireNonNull(profile, "'profile' cannot be null.");
        return new KustoManager(httpPipeline, profile, null);
    }

    public static Configurable configure() {
        return new Configurable();
    }

    public Clusters clusters() {
        if (this.clusters == null) {
            this.clusters = new ClustersImpl(this.clientObject.getClusters(), this);
        }
        return this.clusters;
    }

    public ClusterPrincipalAssignments clusterPrincipalAssignments() {
        if (this.clusterPrincipalAssignments == null) {
            this.clusterPrincipalAssignments = new ClusterPrincipalAssignmentsImpl(this.clientObject.getClusterPrincipalAssignments(), this);
        }
        return this.clusterPrincipalAssignments;
    }

    public Skus skus() {
        if (this.skus == null) {
            this.skus = new SkusImpl(this.clientObject.getSkus(), this);
        }
        return this.skus;
    }

    public Databases databases() {
        if (this.databases == null) {
            this.databases = new DatabasesImpl(this.clientObject.getDatabases(), this);
        }
        return this.databases;
    }

    public AttachedDatabaseConfigurations attachedDatabaseConfigurations() {
        if (this.attachedDatabaseConfigurations == null) {
            this.attachedDatabaseConfigurations = new AttachedDatabaseConfigurationsImpl(this.clientObject.getAttachedDatabaseConfigurations(), this);
        }
        return this.attachedDatabaseConfigurations;
    }

    public ManagedPrivateEndpoints managedPrivateEndpoints() {
        if (this.managedPrivateEndpoints == null) {
            this.managedPrivateEndpoints = new ManagedPrivateEndpointsImpl(this.clientObject.getManagedPrivateEndpoints(), this);
        }
        return this.managedPrivateEndpoints;
    }

    public DatabaseOperations databaseOperations() {
        if (this.databaseOperations == null) {
            this.databaseOperations = new DatabaseOperationsImpl(this.clientObject.getDatabaseOperations(), this);
        }
        return this.databaseOperations;
    }

    public DatabasePrincipalAssignments databasePrincipalAssignments() {
        if (this.databasePrincipalAssignments == null) {
            this.databasePrincipalAssignments = new DatabasePrincipalAssignmentsImpl(this.clientObject.getDatabasePrincipalAssignments(), this);
        }
        return this.databasePrincipalAssignments;
    }

    public Scripts scripts() {
        if (this.scripts == null) {
            this.scripts = new ScriptsImpl(this.clientObject.getScripts(), this);
        }
        return this.scripts;
    }

    public SandboxCustomImages sandboxCustomImages() {
        if (this.sandboxCustomImages == null) {
            this.sandboxCustomImages = new SandboxCustomImagesImpl(this.clientObject.getSandboxCustomImages(), this);
        }
        return this.sandboxCustomImages;
    }

    public PrivateEndpointConnections privateEndpointConnections() {
        if (this.privateEndpointConnections == null) {
            this.privateEndpointConnections = new PrivateEndpointConnectionsImpl(this.clientObject.getPrivateEndpointConnections(), this);
        }
        return this.privateEndpointConnections;
    }

    public PrivateLinkResources privateLinkResources() {
        if (this.privateLinkResources == null) {
            this.privateLinkResources = new PrivateLinkResourcesImpl(this.clientObject.getPrivateLinkResources(), this);
        }
        return this.privateLinkResources;
    }

    public DataConnections dataConnections() {
        if (this.dataConnections == null) {
            this.dataConnections = new DataConnectionsImpl(this.clientObject.getDataConnections(), this);
        }
        return this.dataConnections;
    }

    public Operations operations() {
        if (this.operations == null) {
            this.operations = new OperationsImpl(this.clientObject.getOperations(), this);
        }
        return this.operations;
    }

    public OperationsResults operationsResults() {
        if (this.operationsResults == null) {
            this.operationsResults = new OperationsResultsImpl(this.clientObject.getOperationsResults(), this);
        }
        return this.operationsResults;
    }

    public OperationsResultsLocations operationsResultsLocations() {
        if (this.operationsResultsLocations == null) {
            this.operationsResultsLocations = new OperationsResultsLocationsImpl(this.clientObject.getOperationsResultsLocations(), this);
        }
        return this.operationsResultsLocations;
    }

    public KustoManagementClient serviceClient() {
        return this.clientObject;
    }

    public static final class Configurable {
        private static final ClientLogger LOGGER = new ClientLogger(Configurable.class);
        private HttpClient httpClient;
        private HttpLogOptions httpLogOptions;
        private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        private final List<String> scopes = new ArrayList<String>();
        private RetryPolicy retryPolicy;
        private RetryOptions retryOptions;
        private Duration defaultPollInterval;

        private Configurable() {
        }

        public Configurable withHttpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "'httpClient' cannot be null.");
            return this;
        }

        public Configurable withLogOptions(HttpLogOptions httpLogOptions) {
            this.httpLogOptions = Objects.requireNonNull(httpLogOptions, "'httpLogOptions' cannot be null.");
            return this;
        }

        public Configurable withPolicy(HttpPipelinePolicy policy) {
            this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
            return this;
        }

        public Configurable withScope(String scope) {
            this.scopes.add(Objects.requireNonNull(scope, "'scope' cannot be null."));
            return this;
        }

        public Configurable withRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = Objects.requireNonNull(retryPolicy, "'retryPolicy' cannot be null.");
            return this;
        }

        public Configurable withRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
            return this;
        }

        public Configurable withDefaultPollInterval(Duration defaultPollInterval) {
            this.defaultPollInterval = Objects.requireNonNull(defaultPollInterval, "'defaultPollInterval' cannot be null.");
            if (this.defaultPollInterval.isNegative()) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'defaultPollInterval' cannot be negative"));
            }
            return this;
        }

        public KustoManager authenticate(TokenCredential credential, AzureProfile profile) {
            Objects.requireNonNull(credential, "'credential' cannot be null.");
            Objects.requireNonNull(profile, "'profile' cannot be null.");
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("azsdk-java").append("-").append("com.azure.resourcemanager.kusto").append("/").append("1.0.0");
            if (!((Boolean)Configuration.getGlobalConfiguration().get("AZURE_TELEMETRY_DISABLED", (Object)false)).booleanValue()) {
                userAgentBuilder.append(" (").append(Configuration.getGlobalConfiguration().get("java.version")).append("; ").append(Configuration.getGlobalConfiguration().get("os.name")).append("; ").append(Configuration.getGlobalConfiguration().get("os.version")).append("; auto-generated)");
            } else {
                userAgentBuilder.append(" (auto-generated)");
            }
            if (this.scopes.isEmpty()) {
                this.scopes.add(profile.getEnvironment().getManagementEndpoint() + "/.default");
            }
            if (this.retryPolicy == null) {
                this.retryPolicy = this.retryOptions != null ? new RetryPolicy(this.retryOptions) : new RetryPolicy("Retry-After", ChronoUnit.SECONDS);
            }
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(userAgentBuilder.toString()));
            policies.add(new AddHeadersFromContextPolicy());
            policies.add(new RequestIdPolicy());
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_CALL).collect(Collectors.toList()));
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new ArmChallengeAuthenticationPolicy(credential, this.scopes.toArray(new String[0])));
            policies.addAll(this.policies.stream().filter(p -> p.getPipelinePosition() == HttpPipelinePosition.PER_RETRY).collect(Collectors.toList()));
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            HttpPipeline httpPipeline = new HttpPipelineBuilder().httpClient(this.httpClient).policies(policies.toArray(new HttpPipelinePolicy[0])).build();
            return new KustoManager(httpPipeline, profile, this.defaultPollInterval);
        }
    }
}

