/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.DefaultPrincipalsModificationKind;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.TableLevelSharingProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AttachedDatabaseConfigurationProperties {
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="databaseName", required=true)
    private String databaseName;
    @JsonProperty(value="clusterResourceId", required=true)
    private String clusterResourceId;
    @JsonProperty(value="attachedDatabaseNames", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> attachedDatabaseNames;
    @JsonProperty(value="defaultPrincipalsModificationKind", required=true)
    private DefaultPrincipalsModificationKind defaultPrincipalsModificationKind;
    @JsonProperty(value="tableLevelSharingProperties")
    private TableLevelSharingProperties tableLevelSharingProperties;
    @JsonProperty(value="databaseNameOverride")
    private String databaseNameOverride;
    @JsonProperty(value="databaseNamePrefix")
    private String databaseNamePrefix;
    private static final ClientLogger LOGGER = new ClientLogger(AttachedDatabaseConfigurationProperties.class);

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public String clusterResourceId() {
        return this.clusterResourceId;
    }

    public AttachedDatabaseConfigurationProperties withClusterResourceId(String clusterResourceId) {
        this.clusterResourceId = clusterResourceId;
        return this;
    }

    public List<String> attachedDatabaseNames() {
        return this.attachedDatabaseNames;
    }

    public DefaultPrincipalsModificationKind defaultPrincipalsModificationKind() {
        return this.defaultPrincipalsModificationKind;
    }

    public AttachedDatabaseConfigurationProperties withDefaultPrincipalsModificationKind(DefaultPrincipalsModificationKind defaultPrincipalsModificationKind) {
        this.defaultPrincipalsModificationKind = defaultPrincipalsModificationKind;
        return this;
    }

    public TableLevelSharingProperties tableLevelSharingProperties() {
        return this.tableLevelSharingProperties;
    }

    public AttachedDatabaseConfigurationProperties withTableLevelSharingProperties(TableLevelSharingProperties tableLevelSharingProperties) {
        this.tableLevelSharingProperties = tableLevelSharingProperties;
        return this;
    }

    public String databaseNameOverride() {
        return this.databaseNameOverride;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseNameOverride(String databaseNameOverride) {
        this.databaseNameOverride = databaseNameOverride;
        return this;
    }

    public String databaseNamePrefix() {
        return this.databaseNamePrefix;
    }

    public AttachedDatabaseConfigurationProperties withDatabaseNamePrefix(String databaseNamePrefix) {
        this.databaseNamePrefix = databaseNamePrefix;
        return this;
    }

    public void validate() {
        if (this.databaseName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.clusterResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property clusterResourceId in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.defaultPrincipalsModificationKind() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property defaultPrincipalsModificationKind in model AttachedDatabaseConfigurationProperties"));
        }
        if (this.tableLevelSharingProperties() != null) {
            this.tableLevelSharingProperties().validate();
        }
    }
}

