/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.resourcemanager.kusto.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.kusto.models.AcceptedAudiences;
import com.azure.resourcemanager.kusto.models.ClusterNetworkAccessFlag;
import com.azure.resourcemanager.kusto.models.EngineType;
import com.azure.resourcemanager.kusto.models.KeyVaultProperties;
import com.azure.resourcemanager.kusto.models.LanguageExtensionsList;
import com.azure.resourcemanager.kusto.models.MigrationClusterProperties;
import com.azure.resourcemanager.kusto.models.OptimizedAutoscale;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.azure.resourcemanager.kusto.models.PublicIpType;
import com.azure.resourcemanager.kusto.models.PublicNetworkAccess;
import com.azure.resourcemanager.kusto.models.State;
import com.azure.resourcemanager.kusto.models.TrustedExternalTenant;
import com.azure.resourcemanager.kusto.models.VirtualNetworkConfiguration;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ClusterProperties {
    @JsonProperty(value="state", access=JsonProperty.Access.WRITE_ONLY)
    private State state;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    @JsonProperty(value="uri", access=JsonProperty.Access.WRITE_ONLY)
    private String uri;
    @JsonProperty(value="dataIngestionUri", access=JsonProperty.Access.WRITE_ONLY)
    private String dataIngestionUri;
    @JsonProperty(value="stateReason", access=JsonProperty.Access.WRITE_ONLY)
    private String stateReason;
    @JsonProperty(value="trustedExternalTenants")
    private List<TrustedExternalTenant> trustedExternalTenants;
    @JsonProperty(value="optimizedAutoscale")
    private OptimizedAutoscale optimizedAutoscale;
    @JsonProperty(value="enableDiskEncryption")
    private Boolean enableDiskEncryption;
    @JsonProperty(value="enableStreamingIngest")
    private Boolean enableStreamingIngest;
    @JsonProperty(value="virtualNetworkConfiguration")
    private VirtualNetworkConfiguration virtualNetworkConfiguration;
    @JsonProperty(value="keyVaultProperties")
    private KeyVaultProperties keyVaultProperties;
    @JsonProperty(value="enablePurge")
    private Boolean enablePurge;
    @JsonProperty(value="languageExtensions")
    private LanguageExtensionsList languageExtensions;
    @JsonProperty(value="enableDoubleEncryption")
    private Boolean enableDoubleEncryption;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;
    @JsonProperty(value="allowedIpRangeList")
    private List<String> allowedIpRangeList;
    @JsonProperty(value="engineType")
    private EngineType engineType;
    @JsonProperty(value="acceptedAudiences")
    private List<AcceptedAudiences> acceptedAudiences;
    @JsonProperty(value="enableAutoStop")
    private Boolean enableAutoStop;
    @JsonProperty(value="restrictOutboundNetworkAccess")
    private ClusterNetworkAccessFlag restrictOutboundNetworkAccess;
    @JsonProperty(value="allowedFqdnList")
    private List<String> allowedFqdnList;
    @JsonProperty(value="publicIPType")
    private PublicIpType publicIpType;
    @JsonProperty(value="virtualClusterGraduationProperties")
    private String virtualClusterGraduationProperties;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="migrationCluster", access=JsonProperty.Access.WRITE_ONLY)
    private MigrationClusterProperties migrationCluster;

    public State state() {
        return this.state;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String uri() {
        return this.uri;
    }

    public String dataIngestionUri() {
        return this.dataIngestionUri;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public List<TrustedExternalTenant> trustedExternalTenants() {
        return this.trustedExternalTenants;
    }

    public ClusterProperties withTrustedExternalTenants(List<TrustedExternalTenant> trustedExternalTenants) {
        this.trustedExternalTenants = trustedExternalTenants;
        return this;
    }

    public OptimizedAutoscale optimizedAutoscale() {
        return this.optimizedAutoscale;
    }

    public ClusterProperties withOptimizedAutoscale(OptimizedAutoscale optimizedAutoscale) {
        this.optimizedAutoscale = optimizedAutoscale;
        return this;
    }

    public Boolean enableDiskEncryption() {
        return this.enableDiskEncryption;
    }

    public ClusterProperties withEnableDiskEncryption(Boolean enableDiskEncryption) {
        this.enableDiskEncryption = enableDiskEncryption;
        return this;
    }

    public Boolean enableStreamingIngest() {
        return this.enableStreamingIngest;
    }

    public ClusterProperties withEnableStreamingIngest(Boolean enableStreamingIngest) {
        this.enableStreamingIngest = enableStreamingIngest;
        return this;
    }

    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.virtualNetworkConfiguration;
    }

    public ClusterProperties withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        this.virtualNetworkConfiguration = virtualNetworkConfiguration;
        return this;
    }

    public KeyVaultProperties keyVaultProperties() {
        return this.keyVaultProperties;
    }

    public ClusterProperties withKeyVaultProperties(KeyVaultProperties keyVaultProperties) {
        this.keyVaultProperties = keyVaultProperties;
        return this;
    }

    public Boolean enablePurge() {
        return this.enablePurge;
    }

    public ClusterProperties withEnablePurge(Boolean enablePurge) {
        this.enablePurge = enablePurge;
        return this;
    }

    public LanguageExtensionsList languageExtensions() {
        return this.languageExtensions;
    }

    public ClusterProperties withLanguageExtensions(LanguageExtensionsList languageExtensions) {
        this.languageExtensions = languageExtensions;
        return this;
    }

    public Boolean enableDoubleEncryption() {
        return this.enableDoubleEncryption;
    }

    public ClusterProperties withEnableDoubleEncryption(Boolean enableDoubleEncryption) {
        this.enableDoubleEncryption = enableDoubleEncryption;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ClusterProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public List<String> allowedIpRangeList() {
        return this.allowedIpRangeList;
    }

    public ClusterProperties withAllowedIpRangeList(List<String> allowedIpRangeList) {
        this.allowedIpRangeList = allowedIpRangeList;
        return this;
    }

    public EngineType engineType() {
        return this.engineType;
    }

    public ClusterProperties withEngineType(EngineType engineType) {
        this.engineType = engineType;
        return this;
    }

    public List<AcceptedAudiences> acceptedAudiences() {
        return this.acceptedAudiences;
    }

    public ClusterProperties withAcceptedAudiences(List<AcceptedAudiences> acceptedAudiences) {
        this.acceptedAudiences = acceptedAudiences;
        return this;
    }

    public Boolean enableAutoStop() {
        return this.enableAutoStop;
    }

    public ClusterProperties withEnableAutoStop(Boolean enableAutoStop) {
        this.enableAutoStop = enableAutoStop;
        return this;
    }

    public ClusterNetworkAccessFlag restrictOutboundNetworkAccess() {
        return this.restrictOutboundNetworkAccess;
    }

    public ClusterProperties withRestrictOutboundNetworkAccess(ClusterNetworkAccessFlag restrictOutboundNetworkAccess) {
        this.restrictOutboundNetworkAccess = restrictOutboundNetworkAccess;
        return this;
    }

    public List<String> allowedFqdnList() {
        return this.allowedFqdnList;
    }

    public ClusterProperties withAllowedFqdnList(List<String> allowedFqdnList) {
        this.allowedFqdnList = allowedFqdnList;
        return this;
    }

    public PublicIpType publicIpType() {
        return this.publicIpType;
    }

    public ClusterProperties withPublicIpType(PublicIpType publicIpType) {
        this.publicIpType = publicIpType;
        return this;
    }

    public String virtualClusterGraduationProperties() {
        return this.virtualClusterGraduationProperties;
    }

    public ClusterProperties withVirtualClusterGraduationProperties(String virtualClusterGraduationProperties) {
        this.virtualClusterGraduationProperties = virtualClusterGraduationProperties;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public MigrationClusterProperties migrationCluster() {
        return this.migrationCluster;
    }

    public void validate() {
        if (this.trustedExternalTenants() != null) {
            this.trustedExternalTenants().forEach(e -> e.validate());
        }
        if (this.optimizedAutoscale() != null) {
            this.optimizedAutoscale().validate();
        }
        if (this.virtualNetworkConfiguration() != null) {
            this.virtualNetworkConfiguration().validate();
        }
        if (this.keyVaultProperties() != null) {
            this.keyVaultProperties().validate();
        }
        if (this.languageExtensions() != null) {
            this.languageExtensions().validate();
        }
        if (this.acceptedAudiences() != null) {
            this.acceptedAudiences().forEach(e -> e.validate());
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.migrationCluster() != null) {
            this.migrationCluster().validate();
        }
    }
}

