/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class CosmosDbDataConnectionProperties {
    @JsonProperty(value="tableName", required=true)
    private String tableName;
    @JsonProperty(value="mappingRuleName")
    private String mappingRuleName;
    @JsonProperty(value="managedIdentityResourceId", required=true)
    private String managedIdentityResourceId;
    @JsonProperty(value="managedIdentityObjectId", access=JsonProperty.Access.WRITE_ONLY)
    private String managedIdentityObjectId;
    @JsonProperty(value="cosmosDbAccountResourceId", required=true)
    private String cosmosDbAccountResourceId;
    @JsonProperty(value="cosmosDbDatabase", required=true)
    private String cosmosDbDatabase;
    @JsonProperty(value="cosmosDbContainer", required=true)
    private String cosmosDbContainer;
    @JsonProperty(value="retrievalStartDate")
    private OffsetDateTime retrievalStartDate;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(CosmosDbDataConnectionProperties.class);

    public String tableName() {
        return this.tableName;
    }

    public CosmosDbDataConnectionProperties withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String mappingRuleName() {
        return this.mappingRuleName;
    }

    public CosmosDbDataConnectionProperties withMappingRuleName(String mappingRuleName) {
        this.mappingRuleName = mappingRuleName;
        return this;
    }

    public String managedIdentityResourceId() {
        return this.managedIdentityResourceId;
    }

    public CosmosDbDataConnectionProperties withManagedIdentityResourceId(String managedIdentityResourceId) {
        this.managedIdentityResourceId = managedIdentityResourceId;
        return this;
    }

    public String managedIdentityObjectId() {
        return this.managedIdentityObjectId;
    }

    public String cosmosDbAccountResourceId() {
        return this.cosmosDbAccountResourceId;
    }

    public CosmosDbDataConnectionProperties withCosmosDbAccountResourceId(String cosmosDbAccountResourceId) {
        this.cosmosDbAccountResourceId = cosmosDbAccountResourceId;
        return this;
    }

    public String cosmosDbDatabase() {
        return this.cosmosDbDatabase;
    }

    public CosmosDbDataConnectionProperties withCosmosDbDatabase(String cosmosDbDatabase) {
        this.cosmosDbDatabase = cosmosDbDatabase;
        return this;
    }

    public String cosmosDbContainer() {
        return this.cosmosDbContainer;
    }

    public CosmosDbDataConnectionProperties withCosmosDbContainer(String cosmosDbContainer) {
        this.cosmosDbContainer = cosmosDbContainer;
        return this;
    }

    public OffsetDateTime retrievalStartDate() {
        return this.retrievalStartDate;
    }

    public CosmosDbDataConnectionProperties withRetrievalStartDate(OffsetDateTime retrievalStartDate) {
        this.retrievalStartDate = retrievalStartDate;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.tableName() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property tableName in model CosmosDbDataConnectionProperties"));
        }
        if (this.managedIdentityResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property managedIdentityResourceId in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbAccountResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbAccountResourceId in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbDatabase() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbDatabase in model CosmosDbDataConnectionProperties"));
        }
        if (this.cosmosDbContainer() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property cosmosDbContainer in model CosmosDbDataConnectionProperties"));
        }
    }
}

