/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.kusto.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalRole;
import com.azure.resourcemanager.kusto.models.DatabasePrincipalType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class DatabasePrincipalInner {
    @JsonProperty(value="role", required=true)
    private DatabasePrincipalRole role;
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="type", required=true)
    private DatabasePrincipalType type;
    @JsonProperty(value="fqn")
    private String fqn;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="appId")
    private String appId;
    @JsonProperty(value="tenantName", access=JsonProperty.Access.WRITE_ONLY)
    private String tenantName;
    private static final ClientLogger LOGGER = new ClientLogger(DatabasePrincipalInner.class);

    public DatabasePrincipalRole role() {
        return this.role;
    }

    public DatabasePrincipalInner withRole(DatabasePrincipalRole role) {
        this.role = role;
        return this;
    }

    public String name() {
        return this.name;
    }

    public DatabasePrincipalInner withName(String name) {
        this.name = name;
        return this;
    }

    public DatabasePrincipalType type() {
        return this.type;
    }

    public DatabasePrincipalInner withType(DatabasePrincipalType type) {
        this.type = type;
        return this;
    }

    public String fqn() {
        return this.fqn;
    }

    public DatabasePrincipalInner withFqn(String fqn) {
        this.fqn = fqn;
        return this;
    }

    public String email() {
        return this.email;
    }

    public DatabasePrincipalInner withEmail(String email) {
        this.email = email;
        return this;
    }

    public String appId() {
        return this.appId;
    }

    public DatabasePrincipalInner withAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public String tenantName() {
        return this.tenantName;
    }

    public void validate() {
        if (this.role() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property role in model DatabasePrincipalInner"));
        }
        if (this.name() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model DatabasePrincipalInner"));
        }
        if (this.type() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model DatabasePrincipalInner"));
        }
    }
}

